/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.i;

public final class NumericRangeQuery<T extends Number>
extends MultiTermQuery {
    final int precisionStep;
    final FieldType.NumericType dataType;
    final T min;
    final T max;
    final boolean minInclusive;
    final boolean maxInclusive;
    static final long LONG_NEGATIVE_INFINITY = i.a(Double.NEGATIVE_INFINITY);
    static final long LONG_POSITIVE_INFINITY = i.a(Double.POSITIVE_INFINITY);
    static final int INT_NEGATIVE_INFINITY = i.a(Float.NEGATIVE_INFINITY);
    static final int INT_POSITIVE_INFINITY = i.a(Float.POSITIVE_INFINITY);

    private NumericRangeQuery(String string, int n2, FieldType.NumericType numericType, T t2, T t3, boolean bl, boolean bl2) {
        super(string);
        if (n2 < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = n2;
        this.dataType = Objects.requireNonNull(numericType, "NumericType must not be null");
        this.min = t2;
        this.max = t3;
        this.minInclusive = bl;
        this.maxInclusive = bl2;
    }

    public static NumericRangeQuery<Long> newLongRange(String string, Long l2, Long l3, boolean bl, boolean bl2) {
        return new NumericRangeQuery<Long>(string, 16, FieldType.NumericType.LONG, l2, l3, bl, bl2);
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource attributeSource) throws IOException {
        if (this.min != null && this.max != null && ((Comparable)this.min).compareTo(this.max) > 0) {
            return TermsEnum.EMPTY;
        }
        return new NumericRangeTermsEnum(terms.iterator());
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.getField().equals(string)) {
            stringBuilder.append(this.getField()).append(':');
        }
        return stringBuilder.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost(this.getBoost())).toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof NumericRangeQuery) {
            NumericRangeQuery numericRangeQuery = (NumericRangeQuery)object;
            return (numericRangeQuery.min == null ? this.min == null : numericRangeQuery.min.equals(this.min)) && (numericRangeQuery.max == null ? this.max == null : numericRangeQuery.max.equals(this.max)) && this.minInclusive == numericRangeQuery.minInclusive && this.maxInclusive == numericRangeQuery.maxInclusive && this.precisionStep == numericRangeQuery.precisionStep;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 += this.precisionStep ^ 0x64365465;
        if (this.min != null) {
            n2 += this.min.hashCode() ^ 0x14FA55FB;
        }
        if (this.max != null) {
            n2 += this.max.hashCode() ^ 0x733FA5FE;
        }
        return n2 + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    private final class NumericRangeTermsEnum
    extends FilteredTermsEnum {
        private BytesRef currentLowerBound;
        private BytesRef currentUpperBound;
        private final LinkedList<BytesRef> rangeBounds;

        NumericRangeTermsEnum(TermsEnum termsEnum) {
            super(termsEnum);
            this.rangeBounds = new LinkedList();
            switch (NumericRangeQuery.this.dataType) {
                case LONG: 
                case DOUBLE: {
                    long l2;
                    long l3;
                    if (NumericRangeQuery.this.dataType == FieldType.NumericType.LONG) {
                        l3 = NumericRangeQuery.this.min == null ? Long.MIN_VALUE : ((Number)NumericRangeQuery.this.min).longValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == FieldType.NumericType.DOUBLE);
                        long l4 = l3 = NumericRangeQuery.this.min == null ? LONG_NEGATIVE_INFINITY : i.a(((Number)NumericRangeQuery.this.min).doubleValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (l3 == Long.MAX_VALUE) break;
                        ++l3;
                    }
                    if (NumericRangeQuery.this.dataType == FieldType.NumericType.LONG) {
                        l2 = NumericRangeQuery.this.max == null ? Long.MAX_VALUE : ((Number)NumericRangeQuery.this.max).longValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == FieldType.NumericType.DOUBLE);
                        long l5 = l2 = NumericRangeQuery.this.max == null ? LONG_POSITIVE_INFINITY : i.a(((Number)NumericRangeQuery.this.max).doubleValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (l2 == Long.MIN_VALUE) break;
                        --l2;
                    }
                    i.a(new i.b(){

                        @Override
                        public final void addRange(BytesRef bytesRef, BytesRef bytesRef2) {
                            NumericRangeTermsEnum.this.rangeBounds.add(bytesRef);
                            NumericRangeTermsEnum.this.rangeBounds.add(bytesRef2);
                        }
                    }, NumericRangeQuery.this.precisionStep, l3, l2);
                    break;
                }
                case INT: 
                case FLOAT: {
                    int n2;
                    int n3;
                    if (NumericRangeQuery.this.dataType == FieldType.NumericType.INT) {
                        n3 = NumericRangeQuery.this.min == null ? Integer.MIN_VALUE : ((Number)NumericRangeQuery.this.min).intValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == FieldType.NumericType.FLOAT);
                        int n4 = n3 = NumericRangeQuery.this.min == null ? INT_NEGATIVE_INFINITY : i.a(((Number)NumericRangeQuery.this.min).floatValue());
                    }
                    if (!NumericRangeQuery.this.minInclusive && NumericRangeQuery.this.min != null) {
                        if (n3 == Integer.MAX_VALUE) break;
                        ++n3;
                    }
                    if (NumericRangeQuery.this.dataType == FieldType.NumericType.INT) {
                        n2 = NumericRangeQuery.this.max == null ? Integer.MAX_VALUE : ((Number)NumericRangeQuery.this.max).intValue();
                    } else {
                        assert (NumericRangeQuery.this.dataType == FieldType.NumericType.FLOAT);
                        int n5 = n2 = NumericRangeQuery.this.max == null ? INT_POSITIVE_INFINITY : i.a(((Number)NumericRangeQuery.this.max).floatValue());
                    }
                    if (!NumericRangeQuery.this.maxInclusive && NumericRangeQuery.this.max != null) {
                        if (n2 == Integer.MIN_VALUE) break;
                        --n2;
                    }
                    i.a(new i.a(){

                        @Override
                        public final void addRange(BytesRef bytesRef, BytesRef bytesRef2) {
                            NumericRangeTermsEnum.this.rangeBounds.add(bytesRef);
                            NumericRangeTermsEnum.this.rangeBounds.add(bytesRef2);
                        }
                    }, NumericRangeQuery.this.precisionStep, n3, n2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid NumericType");
                }
            }
        }

        private void nextRange() {
            assert (this.rangeBounds.size() % 2 == 0);
            this.currentLowerBound = this.rangeBounds.removeFirst();
            assert (this.currentUpperBound == null || this.currentUpperBound.compareTo(this.currentLowerBound) <= 0) : "The current upper bound must be <= the new lower bound";
            this.currentUpperBound = this.rangeBounds.removeFirst();
        }

        @Override
        protected final BytesRef nextSeekTerm(BytesRef bytesRef) {
            while (this.rangeBounds.size() >= 2) {
                this.nextRange();
                if (bytesRef != null && bytesRef.compareTo(this.currentUpperBound) > 0) continue;
                return bytesRef != null && bytesRef.compareTo(this.currentLowerBound) > 0 ? bytesRef : this.currentLowerBound;
            }
            assert (this.rangeBounds.isEmpty());
            this.currentUpperBound = null;
            this.currentLowerBound = null;
            return null;
        }

        @Override
        protected final FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef) {
            while (this.currentUpperBound == null || bytesRef.compareTo(this.currentUpperBound) > 0) {
                if (this.rangeBounds.isEmpty()) {
                    return FilteredTermsEnum.AcceptStatus.END;
                }
                if (bytesRef.compareTo(this.rangeBounds.getFirst()) < 0) {
                    return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
                }
                this.nextRange();
            }
            return FilteredTermsEnum.AcceptStatus.YES;
        }
    }
}

