/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;

final class PhrasePositions {
    int position;
    int count;
    int offset;
    final int ord;
    final PostingsEnum postings;
    int rptGroup = -1;
    int rptInd;
    final Term[] terms;

    PhrasePositions(PostingsEnum postingsEnum, int n2, int n3, Term[] termArray) {
        this.postings = postingsEnum;
        this.offset = n2;
        this.ord = n3;
        this.terms = termArray;
    }

    final void firstPosition() throws IOException {
        this.count = this.postings.freq();
        this.nextPosition();
    }

    final boolean nextPosition() throws IOException {
        if (this.count-- > 0) {
            this.position = this.postings.nextPosition() - this.offset;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "o:" + this.offset + " p:" + this.position + " c:" + this.count;
        if (this.rptGroup >= 0) {
            string = string + " rpt:" + this.rptGroup + ",i" + this.rptInd;
        }
        return string;
    }
}

