/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ReferenceManager<G>
implements Closeable {
    protected volatile G current;
    private final Lock refreshLock = new ReentrantLock();
    private final List<a> refreshListeners = new CopyOnWriteArrayList<a>();

    private void ensureOpen() {
        if (this.current == null) {
            throw new org.apache.lucene.store.a("this ReferenceManager is closed");
        }
    }

    private synchronized void swapReference(G g2) throws IOException {
        this.ensureOpen();
        G g3 = this.current;
        this.current = g2;
        this.release(g3);
    }

    protected abstract void decRef(G var1) throws IOException;

    protected abstract G refreshIfNeeded(G var1) throws IOException;

    protected abstract boolean tryIncRef(G var1) throws IOException;

    public final G acquire() throws IOException {
        G g2;
        do {
            if ((g2 = this.current) == null) {
                throw new org.apache.lucene.store.a("this ReferenceManager is closed");
            }
            if (!this.tryIncRef(g2)) continue;
            return g2;
        } while (this.getRefCount(g2) != 0 || this.current != g2);
        assert (g2 != null);
        throw new IllegalStateException("The managed reference has already closed - this is likely a bug when the reference count is modified outside of the ReferenceManager");
    }

    @Override
    public final synchronized void close() throws IOException {
        if (this.current != null) {
            this.swapReference(null);
            this.afterClose();
        }
    }

    protected abstract int getRefCount(G var1);

    protected void afterClose() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaybeRefresh() throws IOException {
        this.refreshLock.lock();
        boolean bl = false;
        try {
            block11: {
                G g2 = this.acquire();
                try {
                    this.notifyRefreshListenersBefore();
                    G g3 = this.refreshIfNeeded(g2);
                    if (g3 == null) break block11;
                    assert (g3 != g2) : "refreshIfNeeded should return null if refresh wasn't needed";
                    try {
                        this.swapReference(g3);
                        bl = true;
                    }
                    finally {
                        if (!bl) {
                            this.release(g3);
                        }
                    }
                }
                finally {
                    this.release(g2);
                    this.notifyRefreshListenersRefreshed(bl);
                }
            }
            this.afterMaybeRefresh();
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    public final boolean maybeRefresh() throws IOException {
        this.ensureOpen();
        boolean bl = this.refreshLock.tryLock();
        if (bl) {
            try {
                this.doMaybeRefresh();
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return bl;
    }

    protected void afterMaybeRefresh() throws IOException {
    }

    public final void release(G g2) throws IOException {
        assert (g2 != null);
        this.decRef(g2);
    }

    private void notifyRefreshListenersBefore() throws IOException {
        for (a a2 : this.refreshListeners) {
            a2.a();
        }
    }

    private void notifyRefreshListenersRefreshed(boolean bl) throws IOException {
        for (a a2 : this.refreshListeners) {
            a2.a(bl);
        }
    }

    public static interface a {
        public void a() throws IOException;

        public void a(boolean var1) throws IOException;
    }
}

