/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermCollectingRewrite;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class ScoringRewrite<B>
extends TermCollectingRewrite<B> {
    public static final ScoringRewrite<BooleanQuery.Builder> SCORING_BOOLEAN_REWRITE = new ScoringRewrite<BooleanQuery.Builder>(){

        protected BooleanQuery.Builder a() {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            return builder;
        }

        protected Query a(BooleanQuery.Builder builder) {
            return builder.build();
        }

        protected void a(BooleanQuery.Builder builder, Term term, int n2, float f2, TermContext termContext) {
            TermQuery termQuery = new TermQuery(term, termContext);
            termQuery.setBoost(f2);
            builder.add(termQuery, BooleanClause.Occur.SHOULD);
        }

        @Override
        protected void checkMaxClauseCount(int n2) {
            if (n2 > BooleanQuery.getMaxClauseCount()) {
                throw new BooleanQuery.a();
            }
        }

        @Override
        protected /* synthetic */ void addClause(Object object, Term term, int n2, float f2, TermContext termContext) throws IOException {
            this.a((BooleanQuery.Builder)object, term, n2, f2, termContext);
        }

        @Override
        protected /* synthetic */ Query build(Object object) {
            return this.a((BooleanQuery.Builder)object);
        }

        @Override
        protected /* synthetic */ Object getTopLevelBuilder() throws IOException {
            return this.a();
        }
    };
    public static final MultiTermQuery.a CONSTANT_SCORE_BOOLEAN_REWRITE = new MultiTermQuery.a(){

        @Override
        public Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
            Query query = SCORING_BOOLEAN_REWRITE.rewrite(indexReader, multiTermQuery);
            ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(query);
            constantScoreQuery.setBoost(multiTermQuery.getBoost());
            return constantScoreQuery;
        }
    };

    protected abstract void checkMaxClauseCount(int var1) throws IOException;

    @Override
    public final Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
        Object b2 = this.getTopLevelBuilder();
        ParallelArraysTermCollector parallelArraysTermCollector = new ParallelArraysTermCollector();
        this.collectTerms(indexReader, multiTermQuery, parallelArraysTermCollector);
        int n2 = parallelArraysTermCollector.terms.size();
        if (n2 > 0) {
            int[] nArray = parallelArraysTermCollector.terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
            float[] fArray = parallelArraysTermCollector.array.boost;
            TermContext[] termContextArray = parallelArraysTermCollector.array.termState;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                Term term = new Term(multiTermQuery.getField(), parallelArraysTermCollector.terms.get(n3, new BytesRef()));
                assert (!termContextArray[n3].hasOnlyRealTerms() || indexReader.docFreq(term) == termContextArray[n3].docFreq());
                this.addClause(b2, term, termContextArray[n3].docFreq(), multiTermQuery.getBoost() * fArray[n3], termContextArray[n3]);
            }
        }
        return this.build(b2);
    }

    static final class TermFreqBoostByteStart
    extends BytesRefHash.DirectBytesStartArray {
        float[] boost;
        TermContext[] termState;

        public TermFreqBoostByteStart(int n2) {
            super(n2);
        }

        @Override
        public int[] init() {
            int[] nArray = super.init();
            this.boost = new float[ArrayUtil.oversize(nArray.length, 4)];
            this.termState = new TermContext[ArrayUtil.oversize(nArray.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            assert (this.termState.length >= nArray.length && this.boost.length >= nArray.length);
            return nArray;
        }

        @Override
        public int[] grow() {
            int[] nArray = super.grow();
            this.boost = ArrayUtil.grow(this.boost, nArray.length);
            if (this.termState.length < nArray.length) {
                TermContext[] termContextArray = new TermContext[ArrayUtil.oversize(nArray.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.termState, 0, termContextArray, 0, this.termState.length);
                this.termState = termContextArray;
            }
            assert (this.termState.length >= nArray.length && this.boost.length >= nArray.length);
            return nArray;
        }

        @Override
        public int[] clear() {
            this.boost = null;
            this.termState = null;
            return super.clear();
        }
    }

    final class ParallelArraysTermCollector
    extends TermCollectingRewrite.TermCollector {
        final TermFreqBoostByteStart array = new TermFreqBoostByteStart(16);
        final BytesRefHash terms = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.a()), 16, this.array);
        TermsEnum termsEnum;
        private BoostAttribute boostAtt;

        ParallelArraysTermCollector() {
        }

        @Override
        public void setNextEnum(TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
            this.boostAtt = termsEnum.attributes().addAttribute(BoostAttribute.class);
        }

        @Override
        public boolean collect(BytesRef bytesRef) throws IOException {
            int n2 = this.terms.add(bytesRef);
            q q2 = this.termsEnum.termState();
            assert (q2 != null);
            if (n2 < 0) {
                int n3 = -n2 - 1;
                this.array.termState[n3].register(q2, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                assert (this.array.boost[n3] == this.boostAtt.getBoost()) : "boost should be equal in all segment TermsEnums";
            } else {
                this.array.boost[n2] = this.boostAtt.getBoost();
                this.array.termState[n2] = new TermContext(this.topReaderContext, q2, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                ScoringRewrite.this.checkMaxClauseCount(this.terms.size());
            }
            return true;
        }
    }
}

