/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.m;

public final class SearcherManager
extends ReferenceManager<IndexSearcher> {
    private final m searcherFactory;

    public SearcherManager(IndexWriter indexWriter, boolean bl, m m2) throws IOException {
        if (m2 == null) {
            m2 = new m();
        }
        this.searcherFactory = m2;
        this.current = SearcherManager.getSearcher(m2, DirectoryReader.open(indexWriter, bl), null);
    }

    @Override
    protected void decRef(IndexSearcher indexSearcher) throws IOException {
        indexSearcher.getIndexReader().decRef();
    }

    @Override
    protected IndexSearcher refreshIfNeeded(IndexSearcher indexSearcher) throws IOException {
        IndexReader indexReader = indexSearcher.getIndexReader();
        assert (indexReader instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + indexReader;
        DirectoryReader directoryReader = DirectoryReader.openIfChanged((DirectoryReader)indexReader);
        if (directoryReader == null) {
            return null;
        }
        return SearcherManager.getSearcher(this.searcherFactory, directoryReader, indexReader);
    }

    @Override
    protected boolean tryIncRef(IndexSearcher indexSearcher) {
        return indexSearcher.getIndexReader().tryIncRef();
    }

    @Override
    protected int getRefCount(IndexSearcher indexSearcher) {
        return indexSearcher.getIndexReader().getRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSearcher getSearcher(m m2, IndexReader indexReader, IndexReader indexReader2) throws IOException {
        IndexSearcher indexSearcher;
        boolean bl = false;
        try {
            indexSearcher = m2.a(indexReader, indexReader2);
            if (indexSearcher.getIndexReader() != indexReader) {
                throw new IllegalStateException("SearcherFactory must wrap exactly the provided reader (got " + indexSearcher.getIndexReader() + " but expected " + indexReader + ")");
            }
            bl = true;
        }
        finally {
            if (!bl) {
                indexReader.decRef();
            }
        }
        return indexSearcher;
    }
}

