/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.j;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.FixedBitSet;

final class SloppyPhraseScorer
extends Scorer {
    private final ConjunctionDISI conjunction;
    private final PhrasePositions[] phrasePositions;
    private float sloppyFreq;
    private final a.a docScorer;
    private final int slop;
    private final int numPostings;
    private final j pq;
    private int end;
    private boolean hasRpts;
    private boolean checkedRpts;
    private boolean hasMultiTermRpts;
    private PhrasePositions[][] rptGroups;
    private PhrasePositions[] rptStack;
    private int numMatches;
    final boolean needsScores;

    SloppyPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postingsAndFreqArray, int n2, a.a a2, boolean bl) {
        super(weight);
        this.docScorer = a2;
        this.needsScores = bl;
        this.slop = n2;
        this.numPostings = postingsAndFreqArray == null ? 0 : postingsAndFreqArray.length;
        this.pq = new j(postingsAndFreqArray.length);
        DocIdSetIterator[] docIdSetIteratorArray = new DocIdSetIterator[postingsAndFreqArray.length];
        this.phrasePositions = new PhrasePositions[postingsAndFreqArray.length];
        for (int i2 = 0; i2 < postingsAndFreqArray.length; ++i2) {
            docIdSetIteratorArray[i2] = postingsAndFreqArray[i2].postings;
            this.phrasePositions[i2] = new PhrasePositions(postingsAndFreqArray[i2].postings, postingsAndFreqArray[i2].position, i2, postingsAndFreqArray[i2].terms);
        }
        this.conjunction = ConjunctionDISI.intersect(Arrays.asList(docIdSetIteratorArray));
    }

    private float phraseFreq() throws IOException {
        if (!this.initPhrasePositions()) {
            return 0.0f;
        }
        float f2 = 0.0f;
        this.numMatches = 0;
        PhrasePositions phrasePositions = (PhrasePositions)this.pq.pop();
        int n2 = this.end - phrasePositions.position;
        int n3 = ((PhrasePositions)this.pq.top()).position;
        while (this.advancePP(phrasePositions) && (!this.hasRpts || this.advanceRpts(phrasePositions))) {
            if (phrasePositions.position > n3) {
                if (n2 <= this.slop) {
                    f2 += this.docScorer.computeSlopFactor(n2);
                    ++this.numMatches;
                    if (!this.needsScores) {
                        return f2;
                    }
                }
                this.pq.add(phrasePositions);
                phrasePositions = (PhrasePositions)this.pq.pop();
                n3 = ((PhrasePositions)this.pq.top()).position;
                n2 = this.end - phrasePositions.position;
                continue;
            }
            int n4 = this.end - phrasePositions.position;
            if (n4 >= n2) continue;
            n2 = n4;
        }
        if (n2 <= this.slop) {
            f2 += this.docScorer.computeSlopFactor(n2);
            ++this.numMatches;
        }
        return f2;
    }

    private boolean advancePP(PhrasePositions phrasePositions) throws IOException {
        if (!phrasePositions.nextPosition()) {
            return false;
        }
        if (phrasePositions.position > this.end) {
            this.end = phrasePositions.position;
        }
        return true;
    }

    private boolean advanceRpts(PhrasePositions phrasePositions) throws IOException {
        int n2;
        if (phrasePositions.rptGroup < 0) {
            return true;
        }
        PhrasePositions[] phrasePositionsArray = this.rptGroups[phrasePositions.rptGroup];
        FixedBitSet fixedBitSet = new FixedBitSet(phrasePositionsArray.length);
        int n3 = phrasePositions.rptInd;
        while ((n2 = this.collide(phrasePositions)) >= 0) {
            if (!this.advancePP(phrasePositions = this.lesser(phrasePositions, phrasePositionsArray[n2]))) {
                return false;
            }
            if (n2 == n3) continue;
            fixedBitSet = FixedBitSet.ensureCapacity(fixedBitSet, n2);
            fixedBitSet.set(n2);
        }
        int n4 = 0;
        int n5 = fixedBitSet.length();
        while (fixedBitSet.cardinality() > 0) {
            PhrasePositions phrasePositions2 = (PhrasePositions)this.pq.pop();
            this.rptStack[n4++] = phrasePositions2;
            if (phrasePositions2.rptGroup < 0 || phrasePositions2.rptInd >= n5 || !fixedBitSet.get(phrasePositions2.rptInd)) continue;
            fixedBitSet.clear(phrasePositions2.rptInd);
        }
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            this.pq.add(this.rptStack[i2]);
        }
        return true;
    }

    private PhrasePositions lesser(PhrasePositions phrasePositions, PhrasePositions phrasePositions2) {
        if (phrasePositions.position < phrasePositions2.position || phrasePositions.position == phrasePositions2.position && phrasePositions.offset < phrasePositions2.offset) {
            return phrasePositions;
        }
        return phrasePositions2;
    }

    private int collide(PhrasePositions phrasePositions) {
        int n2 = this.tpPos(phrasePositions);
        PhrasePositions[] phrasePositionsArray = this.rptGroups[phrasePositions.rptGroup];
        for (int i2 = 0; i2 < phrasePositionsArray.length; ++i2) {
            PhrasePositions phrasePositions2 = phrasePositionsArray[i2];
            if (phrasePositions2 == phrasePositions || this.tpPos(phrasePositions2) != n2) continue;
            return phrasePositions2.rptInd;
        }
        return -1;
    }

    private boolean initPhrasePositions() throws IOException {
        this.end = Integer.MIN_VALUE;
        if (!this.checkedRpts) {
            return this.initFirstTime();
        }
        if (!this.hasRpts) {
            this.initSimple();
            return true;
        }
        return this.initComplex();
    }

    private void initSimple() throws IOException {
        this.pq.clear();
        for (PhrasePositions phrasePositions : this.phrasePositions) {
            phrasePositions.firstPosition();
            if (phrasePositions.position > this.end) {
                this.end = phrasePositions.position;
            }
            this.pq.add(phrasePositions);
        }
    }

    private boolean initComplex() throws IOException {
        this.placeFirstPositions();
        if (!this.advanceRepeatGroups()) {
            return false;
        }
        this.fillQueue();
        return true;
    }

    private void placeFirstPositions() throws IOException {
        for (PhrasePositions phrasePositions : this.phrasePositions) {
            phrasePositions.firstPosition();
        }
    }

    private void fillQueue() {
        this.pq.clear();
        for (PhrasePositions phrasePositions : this.phrasePositions) {
            if (phrasePositions.position > this.end) {
                this.end = phrasePositions.position;
            }
            this.pq.add(phrasePositions);
        }
    }

    private boolean advanceRepeatGroups() throws IOException {
        for (PhrasePositions[] phrasePositionsArray : this.rptGroups) {
            int n2;
            int n3;
            if (this.hasMultiTermRpts) {
                block1: for (n2 = 0; n2 < phrasePositionsArray.length; n2 += n3) {
                    int n4;
                    n3 = 1;
                    PhrasePositions phrasePositions = phrasePositionsArray[n2];
                    while ((n4 = this.collide(phrasePositions)) >= 0) {
                        PhrasePositions phrasePositions2 = this.lesser(phrasePositions, phrasePositionsArray[n4]);
                        if (!this.advancePP(phrasePositions2)) {
                            return false;
                        }
                        if (phrasePositions2.rptInd >= n2) continue;
                        n3 = 0;
                        continue block1;
                    }
                }
                continue;
            }
            for (n3 = 1; n3 < phrasePositionsArray.length; ++n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (phrasePositionsArray[n3].nextPosition()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean initFirstTime() throws IOException {
        this.checkedRpts = true;
        this.placeFirstPositions();
        LinkedHashMap<Term, Integer> linkedHashMap = this.repeatingTerms();
        boolean bl = this.hasRpts = !linkedHashMap.isEmpty();
        if (this.hasRpts) {
            this.rptStack = new PhrasePositions[this.numPostings];
            ArrayList<ArrayList<PhrasePositions>> arrayList = this.gatherRptGroups(linkedHashMap);
            this.sortRptGroups(arrayList);
            if (!this.advanceRepeatGroups()) {
                return false;
            }
        }
        this.fillQueue();
        return true;
    }

    private void sortRptGroups(ArrayList<ArrayList<PhrasePositions>> arrayList) {
        this.rptGroups = new PhrasePositions[arrayList.size()][];
        Comparator<PhrasePositions> comparator = new Comparator<PhrasePositions>(){

            @Override
            public int compare(PhrasePositions phrasePositions, PhrasePositions phrasePositions2) {
                return phrasePositions.offset - phrasePositions2.offset;
            }
        };
        for (int i2 = 0; i2 < this.rptGroups.length; ++i2) {
            PhrasePositions[] phrasePositionsArray = arrayList.get(i2).toArray(new PhrasePositions[0]);
            Arrays.sort(phrasePositionsArray, comparator);
            this.rptGroups[i2] = phrasePositionsArray;
            for (int i3 = 0; i3 < phrasePositionsArray.length; ++i3) {
                phrasePositionsArray[i3].rptInd = i3;
            }
        }
    }

    private ArrayList<ArrayList<PhrasePositions>> gatherRptGroups(LinkedHashMap<Term, Integer> linkedHashMap) throws IOException {
        PhrasePositions[] phrasePositionsArray = this.repeatingPPs(linkedHashMap);
        ArrayList<ArrayList<PhrasePositions>> arrayList = new ArrayList<ArrayList<PhrasePositions>>();
        if (!this.hasMultiTermRpts) {
            for (int i2 = 0; i2 < phrasePositionsArray.length; ++i2) {
                PhrasePositions phrasePositions = phrasePositionsArray[i2];
                if (phrasePositions.rptGroup >= 0) continue;
                int n2 = this.tpPos(phrasePositions);
                for (int i3 = i2 + 1; i3 < phrasePositionsArray.length; ++i3) {
                    PhrasePositions phrasePositions2 = phrasePositionsArray[i3];
                    if (phrasePositions2.rptGroup >= 0 || phrasePositions2.offset == phrasePositions.offset || this.tpPos(phrasePositions2) != n2) continue;
                    int n3 = phrasePositions.rptGroup;
                    if (n3 < 0) {
                        phrasePositions.rptGroup = n3 = arrayList.size();
                        ArrayList<PhrasePositions> arrayList2 = new ArrayList<PhrasePositions>(2);
                        arrayList2.add(phrasePositions);
                        arrayList.add(arrayList2);
                    }
                    phrasePositions2.rptGroup = n3;
                    arrayList.get(n3).add(phrasePositions2);
                }
            }
        } else {
            ArrayList arrayList3 = new ArrayList();
            ArrayList<FixedBitSet> arrayList4 = this.ppTermsBitSets(phrasePositionsArray, linkedHashMap);
            this.unionTermGroups(arrayList4);
            HashMap<Term, Integer> hashMap = this.termGroups(linkedHashMap, arrayList4);
            HashSet<Integer> hashSet = new HashSet<Integer>(hashMap.values());
            for (int i4 = 0; i4 < hashSet.size(); ++i4) {
                arrayList3.add(new HashSet());
            }
            for (PhrasePositions phrasePositions : phrasePositionsArray) {
                for (Term term : phrasePositions.terms) {
                    if (!linkedHashMap.containsKey(term)) continue;
                    int n4 = hashMap.get(term);
                    ((HashSet)arrayList3.get(n4)).add(phrasePositions);
                    assert (phrasePositions.rptGroup == -1 || phrasePositions.rptGroup == n4);
                    phrasePositions.rptGroup = n4;
                }
            }
            for (HashSet hashSet2 : arrayList3) {
                arrayList.add(new ArrayList(hashSet2));
            }
        }
        return arrayList;
    }

    private final int tpPos(PhrasePositions phrasePositions) {
        return phrasePositions.position + phrasePositions.offset;
    }

    private LinkedHashMap<Term, Integer> repeatingTerms() {
        LinkedHashMap<Term, Integer> linkedHashMap = new LinkedHashMap<Term, Integer>();
        HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
        for (PhrasePositions phrasePositions : this.phrasePositions) {
            for (Term term : phrasePositions.terms) {
                Integer n2 = (Integer)hashMap.get(term);
                Integer n3 = n2 == null ? new Integer(1) : new Integer(1 + n2);
                hashMap.put(term, n3);
                if (n3 != 2) continue;
                linkedHashMap.put(term, linkedHashMap.size());
            }
        }
        return linkedHashMap;
    }

    private PhrasePositions[] repeatingPPs(HashMap<Term, Integer> hashMap) {
        ArrayList<PhrasePositions> arrayList = new ArrayList<PhrasePositions>();
        block0: for (PhrasePositions phrasePositions : this.phrasePositions) {
            for (Term term : phrasePositions.terms) {
                if (!hashMap.containsKey(term)) continue;
                arrayList.add(phrasePositions);
                this.hasMultiTermRpts |= phrasePositions.terms.length > 1;
                continue block0;
            }
        }
        return arrayList.toArray(new PhrasePositions[0]);
    }

    private ArrayList<FixedBitSet> ppTermsBitSets(PhrasePositions[] phrasePositionsArray, HashMap<Term, Integer> hashMap) {
        ArrayList<FixedBitSet> arrayList = new ArrayList<FixedBitSet>(phrasePositionsArray.length);
        for (PhrasePositions phrasePositions : phrasePositionsArray) {
            FixedBitSet fixedBitSet = new FixedBitSet(hashMap.size());
            for (Term term : phrasePositions.terms) {
                Integer n2 = hashMap.get(term);
                if (n2 == null) continue;
                fixedBitSet.set(n2);
            }
            arrayList.add(fixedBitSet);
        }
        return arrayList;
    }

    private void unionTermGroups(ArrayList<FixedBitSet> arrayList) {
        int n2;
        for (int i2 = 0; i2 < arrayList.size() - 1; i2 += n2) {
            n2 = 1;
            int n3 = i2 + 1;
            while (n3 < arrayList.size()) {
                if (arrayList.get(i2).intersects(arrayList.get(n3))) {
                    arrayList.get(i2).or(arrayList.get(n3));
                    arrayList.remove(n3);
                    n2 = 0;
                    continue;
                }
                ++n3;
            }
        }
    }

    private HashMap<Term, Integer> termGroups(LinkedHashMap<Term, Integer> linkedHashMap, ArrayList<FixedBitSet> arrayList) throws IOException {
        HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
        Term[] termArray = linkedHashMap.keySet().toArray(new Term[0]);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            FixedBitSet fixedBitSet = arrayList.get(i2);
            int n2 = fixedBitSet.nextSetBit(0);
            while (n2 != Integer.MAX_VALUE) {
                hashMap.put(termArray[n2], i2);
                n2 = n2 + 1 >= fixedBitSet.length() ? Integer.MAX_VALUE : fixedBitSet.nextSetBit(n2 + 1);
            }
        }
        return hashMap;
    }

    @Override
    public int freq() {
        return this.numMatches;
    }

    @Override
    public int docID() {
        return this.conjunction.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        int n2 = this.conjunction.nextDoc();
        while (n2 != Integer.MAX_VALUE) {
            this.sloppyFreq = this.phraseFreq();
            if (this.sloppyFreq != 0.0f) break;
            n2 = this.conjunction.nextDoc();
        }
        return n2;
    }

    @Override
    public float score() {
        return this.docScorer.score(this.docID(), this.sloppyFreq);
    }

    @Override
    public int advance(int n2) throws IOException {
        assert (n2 > this.docID());
        int n3 = this.conjunction.advance(n2);
        while (n3 != Integer.MAX_VALUE) {
            this.sloppyFreq = this.phraseFreq();
            if (this.sloppyFreq != 0.0f) break;
            n3 = this.conjunction.nextDoc();
        }
        return n3;
    }

    @Override
    public long cost() {
        return this.conjunction.cost();
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return new TwoPhaseIterator(this.conjunction){

            @Override
            public boolean matches() throws IOException {
                SloppyPhraseScorer.this.sloppyFreq = SloppyPhraseScorer.this.phraseFreq();
                return SloppyPhraseScorer.this.sloppyFreq != 0.0f;
            }
        };
    }
}

