/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.b;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopDocsCollector<T extends ScoreDoc>
implements b {
    protected static final TopDocs EMPTY_TOPDOCS = new TopDocs(0, new ScoreDoc[0], Float.NaN);
    protected PriorityQueue<T> pq;
    protected int totalHits;

    protected TopDocsCollector(PriorityQueue<T> priorityQueue) {
        this.pq = priorityQueue;
    }

    protected void populateResults(ScoreDoc[] scoreDocArray, int n2) {
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            scoreDocArray[i2] = (ScoreDoc)this.pq.pop();
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n2) {
        return scoreDocArray == null ? EMPTY_TOPDOCS : new TopDocs(this.totalHits, scoreDocArray);
    }

    protected int topDocsSize() {
        return this.totalHits < this.pq.size() ? this.totalHits : this.pq.size();
    }

    public TopDocs topDocs() {
        return this.topDocs(0, this.topDocsSize());
    }

    public TopDocs topDocs(int n2, int n3) {
        int n4 = this.topDocsSize();
        if (n2 < 0 || n2 >= n4 || n3 <= 0) {
            return this.newTopDocs(null, n2);
        }
        n3 = Math.min(n4 - n2, n3);
        ScoreDoc[] scoreDocArray = new ScoreDoc[n3];
        for (int i2 = this.pq.size() - n2 - n3; i2 > 0; --i2) {
            this.pq.pop();
        }
        this.populateResults(scoreDocArray, n3);
        return this.newTopDocs(scoreDocArray, n2);
    }
}

