/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.f;
import org.apache.lucene.search.g;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    private final boolean fillFields;
    float maxScore = Float.NaN;
    final int numHits;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;

    private TopFieldCollector(PriorityQueue<FieldValueHitQueue.Entry> priorityQueue, int n2, boolean bl, boolean bl2) {
        super(priorityQueue);
        this.needsScores = bl2;
        this.numHits = n2;
        this.fillFields = bl;
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    public static TopFieldCollector create(Sort sort, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        return TopFieldCollector.create(sort, n2, null, bl, bl2, bl3);
    }

    public static TopFieldCollector create(Sort sort, int n2, FieldDoc fieldDoc, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue = FieldValueHitQueue.create(sort.fields, n2);
        if (fieldDoc == null) {
            if (bl3) {
                return new ScoringMaxScoreCollector(sort, fieldValueHitQueue, n2, bl);
            }
            if (bl2) {
                return new ScoringNoMaxScoreCollector(sort, fieldValueHitQueue, n2, bl);
            }
            return new NonScoringCollector(sort, fieldValueHitQueue, n2, bl);
        }
        if (fieldDoc.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (fieldDoc.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + fieldDoc.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, fieldValueHitQueue, fieldDoc, n2, bl, bl2, bl3);
    }

    final void add(int n2, int n3, float f2) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(n2, this.docBase + n3, f2));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int n2) {
        this.bottom.doc = this.docBase + n2;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    final void updateBottom(int n2, float f2) {
        this.bottom.doc = this.docBase + n2;
        this.bottom.score = f2;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    @Override
    protected void populateResults(ScoreDoc[] scoreDocArray, int n2) {
        if (this.fillFields) {
            FieldValueHitQueue fieldValueHitQueue = (FieldValueHitQueue)this.pq;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                scoreDocArray[i2] = fieldValueHitQueue.fillFields((FieldValueHitQueue.Entry)fieldValueHitQueue.pop());
            }
        } else {
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                FieldValueHitQueue.Entry entry = (FieldValueHitQueue.Entry)this.pq.pop();
                scoreDocArray[i3] = new FieldDoc(entry.doc, entry.score);
            }
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n2) {
        if (scoreDocArray == null) {
            scoreDocArray = EMPTY_SCOREDOCS;
            this.maxScore = Float.NaN;
        }
        return new TopFieldDocs(this.totalHits, scoreDocArray, ((FieldValueHitQueue)this.pq).getFields(), this.maxScore);
    }

    @Override
    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    private static final class PagingFieldCollector
    extends TopFieldCollector {
        int collectedHits;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final boolean trackDocScores;
        final boolean trackMaxScore;
        final FieldDoc after;

        public PagingFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, FieldDoc fieldDoc, int n2, boolean bl, boolean bl2, boolean bl3) {
            super(fieldValueHitQueue, n2, bl, bl2 || bl3 || sort.needsScores());
            this.queue = fieldValueHitQueue;
            this.trackDocScores = bl2;
            this.trackMaxScore = bl3;
            this.after = fieldDoc;
            this.maxScore = Float.NEGATIVE_INFINITY;
            FieldComparator<?>[] fieldComparatorArray = fieldValueHitQueue.comparators;
            for (int i2 = 0; i2 < fieldComparatorArray.length; ++i2) {
                FieldComparator<?> fieldComparator = fieldComparatorArray[i2];
                fieldComparator.setTopValue(fieldDoc.fields[i2]);
            }
        }

        @Override
        public f getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            this.docBase = leafReaderContext.docBase;
            final int n2 = this.after.doc - this.docBase;
            return new MultiComparatorLeafCollector(this.queue.getComparators(leafReaderContext), this.queue.getReverseMul()){

                @Override
                public void collect(int n22) throws IOException {
                    int n3;
                    ++totalHits;
                    float f2 = Float.NaN;
                    if (trackMaxScore && (f2 = this.scorer.score()) > maxScore) {
                        maxScore = f2;
                    }
                    if (queueFull && (n3 = this.compareBottom(n22)) <= 0) {
                        return;
                    }
                    n3 = this.compareTop(n22);
                    if (n3 > 0 || n3 == 0 && n22 <= n2) {
                        return;
                    }
                    if (queueFull) {
                        this.copy(bottom.slot, n22);
                        if (trackDocScores && !trackMaxScore) {
                            f2 = this.scorer.score();
                        }
                        this.updateBottom(n22, f2);
                        this.setBottom(bottom.slot);
                    } else {
                        ++collectedHits;
                        int n4 = collectedHits - 1;
                        this.copy(n4, n22);
                        if (trackDocScores && !trackMaxScore) {
                            f2 = this.scorer.score();
                        }
                        bottom = pq.add(new FieldValueHitQueue.Entry(n4, docBase + n22, f2));
                        boolean bl = queueFull = collectedHits == numHits;
                        if (queueFull) {
                            this.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class ScoringMaxScoreCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public ScoringMaxScoreCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n2, boolean bl) {
            super(fieldValueHitQueue, n2, bl, true);
            this.queue = fieldValueHitQueue;
            this.maxScore = Float.MIN_NORMAL;
        }

        @Override
        public f getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            this.docBase = leafReaderContext.docBase;
            g[] gArray = this.queue.getComparators(leafReaderContext);
            int[] nArray = this.queue.getReverseMul();
            if (gArray.length == 1) {
                return new OneComparatorLeafCollector(gArray[0], nArray[0]){

                    @Override
                    public void collect(int n2) throws IOException {
                        float f2 = this.scorer.score();
                        if (f2 > maxScore) {
                            maxScore = f2;
                        }
                        ++totalHits;
                        if (queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(n2) <= 0) {
                                return;
                            }
                            this.comparator.copy(bottom.slot, n2);
                            this.updateBottom(n2, f2);
                            this.comparator.setBottom(bottom.slot);
                        } else {
                            int n3 = totalHits - 1;
                            this.comparator.copy(n3, n2);
                            this.add(n3, n2, f2);
                            if (queueFull) {
                                this.comparator.setBottom(bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(gArray, nArray){

                @Override
                public void collect(int n2) throws IOException {
                    float f2 = this.scorer.score();
                    if (f2 > maxScore) {
                        maxScore = f2;
                    }
                    ++totalHits;
                    if (queueFull) {
                        if (this.compareBottom(n2) <= 0) {
                            return;
                        }
                        this.copy(bottom.slot, n2);
                        this.updateBottom(n2, f2);
                        this.setBottom(bottom.slot);
                    } else {
                        int n3 = totalHits - 1;
                        this.copy(n3, n2);
                        this.add(n3, n2, f2);
                        if (queueFull) {
                            this.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class ScoringNoMaxScoreCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public ScoringNoMaxScoreCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n2, boolean bl) {
            super(fieldValueHitQueue, n2, bl, true);
            this.queue = fieldValueHitQueue;
        }

        @Override
        public f getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            this.docBase = leafReaderContext.docBase;
            g[] gArray = this.queue.getComparators(leafReaderContext);
            int[] nArray = this.queue.getReverseMul();
            if (gArray.length == 1) {
                return new OneComparatorLeafCollector(gArray[0], nArray[0]){

                    @Override
                    public void collect(int n2) throws IOException {
                        ++totalHits;
                        if (queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(n2) <= 0) {
                                return;
                            }
                            float f2 = this.scorer.score();
                            this.comparator.copy(bottom.slot, n2);
                            this.updateBottom(n2, f2);
                            this.comparator.setBottom(bottom.slot);
                        } else {
                            float f3 = this.scorer.score();
                            int n3 = totalHits - 1;
                            this.comparator.copy(n3, n2);
                            this.add(n3, n2, f3);
                            if (queueFull) {
                                this.comparator.setBottom(bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(gArray, nArray){

                @Override
                public void collect(int n2) throws IOException {
                    ++totalHits;
                    if (queueFull) {
                        if (this.compareBottom(n2) <= 0) {
                            return;
                        }
                        float f2 = this.scorer.score();
                        this.copy(bottom.slot, n2);
                        this.updateBottom(n2, f2);
                        this.setBottom(bottom.slot);
                    } else {
                        float f3 = this.scorer.score();
                        int n3 = totalHits - 1;
                        this.copy(n3, n2);
                        this.add(n3, n2, f3);
                        if (queueFull) {
                            this.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class NonScoringCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public NonScoringCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n2, boolean bl) {
            super(fieldValueHitQueue, n2, bl, sort.needsScores());
            this.queue = fieldValueHitQueue;
        }

        @Override
        public f getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            this.docBase = leafReaderContext.docBase;
            g[] gArray = this.queue.getComparators(leafReaderContext);
            int[] nArray = this.queue.getReverseMul();
            if (gArray.length == 1) {
                return new OneComparatorLeafCollector(gArray[0], nArray[0]){

                    @Override
                    public void collect(int n2) throws IOException {
                        ++totalHits;
                        if (queueFull) {
                            if (this.reverseMul * this.comparator.compareBottom(n2) <= 0) {
                                return;
                            }
                            this.comparator.copy(bottom.slot, n2);
                            this.updateBottom(n2);
                            this.comparator.setBottom(bottom.slot);
                        } else {
                            int n3 = totalHits - 1;
                            this.comparator.copy(n3, n2);
                            this.add(n3, n2, Float.NaN);
                            if (queueFull) {
                                this.comparator.setBottom(bottom.slot);
                            }
                        }
                    }
                };
            }
            return new MultiComparatorLeafCollector(gArray, nArray){

                @Override
                public void collect(int n2) throws IOException {
                    ++totalHits;
                    if (queueFull) {
                        if (this.compareBottom(n2) <= 0) {
                            return;
                        }
                        this.copy(bottom.slot, n2);
                        this.updateBottom(n2);
                        this.setBottom(bottom.slot);
                    } else {
                        int n3 = totalHits - 1;
                        this.copy(n3, n2);
                        this.add(n3, n2, Float.NaN);
                        if (queueFull) {
                            this.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static abstract class MultiComparatorLeafCollector
    implements f {
        final g[] comparators;
        final int[] reverseMul;
        final g firstComparator;
        final int firstReverseMul;
        Scorer scorer;

        MultiComparatorLeafCollector(g[] gArray, int[] nArray) {
            this.comparators = gArray;
            this.reverseMul = nArray;
            this.firstComparator = gArray[0];
            this.firstReverseMul = nArray[0];
        }

        protected final int compareBottom(int n2) throws IOException {
            int n3 = this.firstReverseMul * this.firstComparator.compareBottom(n2);
            if (n3 != 0) {
                return n3;
            }
            for (int i2 = 1; i2 < this.comparators.length; ++i2) {
                n3 = this.reverseMul[i2] * this.comparators[i2].compareBottom(n2);
                if (n3 == 0) continue;
                return n3;
            }
            return 0;
        }

        protected final void copy(int n2, int n3) throws IOException {
            for (g g2 : this.comparators) {
                g2.copy(n2, n3);
            }
        }

        protected final void setBottom(int n2) {
            for (g g2 : this.comparators) {
                g2.setBottom(n2);
            }
        }

        protected final int compareTop(int n2) throws IOException {
            int n3 = this.firstReverseMul * this.firstComparator.compareTop(n2);
            if (n3 != 0) {
                return n3;
            }
            for (int i2 = 1; i2 < this.comparators.length; ++i2) {
                n3 = this.reverseMul[i2] * this.comparators[i2].compareTop(n2);
                if (n3 == 0) continue;
                return n3;
            }
            return 0;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (g g2 : this.comparators) {
                g2.setScorer(scorer);
            }
        }
    }

    private static abstract class OneComparatorLeafCollector
    implements f {
        final g comparator;
        final int reverseMul;
        Scorer scorer;

        OneComparatorLeafCollector(g g2, int n2) {
            this.comparator = g2;
            this.reverseMul = n2;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            this.comparator.setScorer(scorer);
        }
    }
}

