/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.g;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.n;

public abstract class AbstractFirstPassGroupingCollector<GROUP_VALUE_TYPE>
extends n {
    private final Sort groupSort;
    private final FieldComparator<?>[] comparators;
    private final g[] leafComparators;
    private final int[] reversed;
    private final int topNGroups;
    private final HashMap<GROUP_VALUE_TYPE, CollectedSearchGroup<GROUP_VALUE_TYPE>> groupMap;
    private final int compIDXEnd;
    protected TreeSet<CollectedSearchGroup<GROUP_VALUE_TYPE>> orderedGroups;
    private int docBase;
    private int spareSlot;

    public AbstractFirstPassGroupingCollector(Sort sort, int n2) throws IOException {
        if (n2 < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + n2 + ")");
        }
        this.groupSort = sort;
        this.topNGroups = n2;
        SortField[] sortFieldArray = sort.getSort();
        this.comparators = new FieldComparator[sortFieldArray.length];
        this.leafComparators = new g[sortFieldArray.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFieldArray.length];
        for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
            SortField sortField = sortFieldArray[i2];
            this.comparators[i2] = sortField.getComparator(n2 + 1, i2);
            this.reversed[i2] = sortField.getReverse() ? -1 : 1;
        }
        this.spareSlot = n2;
        this.groupMap = new HashMap(n2);
    }

    public Collection<SearchGroup<GROUP_VALUE_TYPE>> getTopGroups(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("groupOffset must be >= 0 (got " + n2 + ")");
        }
        if (this.groupMap.size() <= n2) {
            return null;
        }
        if (this.orderedGroups == null) {
            this.buildSortedSet();
        }
        ArrayList<SearchGroup<GROUP_VALUE_TYPE>> arrayList = new ArrayList<SearchGroup<GROUP_VALUE_TYPE>>();
        int n3 = 0;
        int n4 = this.groupSort.getSort().length;
        for (CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup : this.orderedGroups) {
            if (n3++ < n2) continue;
            SearchGroup searchGroup = new SearchGroup();
            searchGroup.groupValue = collectedSearchGroup.groupValue;
            if (bl) {
                searchGroup.sortValues = new Object[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    searchGroup.sortValues[i2] = this.comparators[i2].value(collectedSearchGroup.comparatorSlot);
                }
            }
            arrayList.add(searchGroup);
        }
        return arrayList;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        for (g g2 : this.leafComparators) {
            g2.setScorer(scorer);
        }
    }

    @Override
    public void collect(int n2) throws IOException {
        CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup;
        int n3;
        GROUP_VALUE_TYPE GROUP_VALUE_TYPE;
        CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup2;
        if (this.orderedGroups != null) {
            int n4 = 0;
            while (true) {
                int n5;
                if ((n5 = this.reversed[n4] * this.leafComparators[n4].compareBottom(n2)) < 0) {
                    return;
                }
                if (n5 > 0) break;
                if (n4 == this.compIDXEnd) {
                    return;
                }
                ++n4;
            }
        }
        if ((collectedSearchGroup2 = this.groupMap.get(GROUP_VALUE_TYPE = this.getDocGroupValue(n2))) == null) {
            if (this.groupMap.size() < this.topNGroups) {
                CollectedSearchGroup collectedSearchGroup3 = new CollectedSearchGroup();
                collectedSearchGroup3.groupValue = this.copyDocGroupValue(GROUP_VALUE_TYPE, null);
                collectedSearchGroup3.comparatorSlot = this.groupMap.size();
                collectedSearchGroup3.topDoc = this.docBase + n2;
                for (g g2 : this.leafComparators) {
                    g2.copy(collectedSearchGroup3.comparatorSlot, n2);
                }
                this.groupMap.put(collectedSearchGroup3.groupValue, collectedSearchGroup3);
                if (this.groupMap.size() == this.topNGroups) {
                    this.buildSortedSet();
                }
                return;
            }
            CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup4 = this.orderedGroups.pollLast();
            assert (this.orderedGroups.size() == this.topNGroups - 1);
            this.groupMap.remove(collectedSearchGroup4.groupValue);
            collectedSearchGroup4.groupValue = this.copyDocGroupValue(GROUP_VALUE_TYPE, collectedSearchGroup4.groupValue);
            collectedSearchGroup4.topDoc = this.docBase + n2;
            for (g g3 : this.leafComparators) {
                g3.copy(collectedSearchGroup4.comparatorSlot, n2);
            }
            this.groupMap.put(collectedSearchGroup4.groupValue, collectedSearchGroup4);
            this.orderedGroups.add(collectedSearchGroup4);
            assert (this.orderedGroups.size() == this.topNGroups);
            int n6 = this.orderedGroups.last().comparatorSlot;
            for (g g4 : this.leafComparators) {
                g4.setBottom(n6);
            }
            return;
        }
        int n7 = 0;
        while (true) {
            this.leafComparators[n7].copy(this.spareSlot, n2);
            n3 = this.reversed[n7] * this.comparators[n7].compare(collectedSearchGroup2.comparatorSlot, this.spareSlot);
            if (n3 < 0) {
                return;
            }
            if (n3 > 0) {
                for (int i2 = n7 + 1; i2 < this.comparators.length; ++i2) {
                    this.leafComparators[i2].copy(this.spareSlot, n2);
                }
                break;
            }
            if (n7 == this.compIDXEnd) {
                return;
            }
            ++n7;
        }
        if (this.orderedGroups != null) {
            collectedSearchGroup = this.orderedGroups.last();
            this.orderedGroups.remove(collectedSearchGroup2);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
        } else {
            collectedSearchGroup = null;
        }
        collectedSearchGroup2.topDoc = this.docBase + n2;
        n3 = this.spareSlot;
        this.spareSlot = collectedSearchGroup2.comparatorSlot;
        collectedSearchGroup2.comparatorSlot = n3;
        if (this.orderedGroups != null) {
            this.orderedGroups.add(collectedSearchGroup2);
            assert (this.orderedGroups.size() == this.topNGroups);
            CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup5 = this.orderedGroups.last();
            if (collectedSearchGroup2 == collectedSearchGroup5 || collectedSearchGroup != collectedSearchGroup5) {
                for (g g5 : this.leafComparators) {
                    g5.setBottom(collectedSearchGroup5.comparatorSlot);
                }
            }
        }
    }

    private void buildSortedSet() {
        Comparator comparator = new Comparator<CollectedSearchGroup<?>>(){

            @Override
            public int compare(CollectedSearchGroup<?> collectedSearchGroup, CollectedSearchGroup<?> collectedSearchGroup2) {
                int n2 = 0;
                while (true) {
                    FieldComparator fieldComparator = AbstractFirstPassGroupingCollector.this.comparators[n2];
                    int n3 = AbstractFirstPassGroupingCollector.this.reversed[n2] * fieldComparator.compare(collectedSearchGroup.comparatorSlot, collectedSearchGroup2.comparatorSlot);
                    if (n3 != 0) {
                        return n3;
                    }
                    if (n2 == AbstractFirstPassGroupingCollector.this.compIDXEnd) {
                        return collectedSearchGroup.topDoc - collectedSearchGroup2.topDoc;
                    }
                    ++n2;
                }
            }
        };
        this.orderedGroups = new TreeSet(comparator);
        this.orderedGroups.addAll(this.groupMap.values());
        assert (this.orderedGroups.size() > 0);
        for (g g2 : this.leafComparators) {
            g2.setBottom(this.orderedGroups.last().comparatorSlot);
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        this.docBase = leafReaderContext.docBase;
        for (int i2 = 0; i2 < this.comparators.length; ++i2) {
            this.leafComparators[i2] = this.comparators[i2].getLeafComparator(leafReaderContext);
        }
    }

    protected abstract GROUP_VALUE_TYPE getDocGroupValue(int var1);

    protected abstract GROUP_VALUE_TYPE copyDocGroupValue(GROUP_VALUE_TYPE var1, GROUP_VALUE_TYPE var2);
}

