/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.f;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.n;

public abstract class AbstractSecondPassGroupingCollector<GROUP_VALUE_TYPE>
extends n {
    protected final Map<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>> groupMap;
    private final int maxDocsPerGroup;
    protected SearchGroupDocs<GROUP_VALUE_TYPE>[] groupDocs;
    private final Collection<SearchGroup<GROUP_VALUE_TYPE>> groups;
    private final Sort withinGroupSort;
    private final Sort groupSort;
    private int totalHitCount;
    private int totalGroupedHitCount;

    public AbstractSecondPassGroupingCollector(Collection<SearchGroup<GROUP_VALUE_TYPE>> collection, Sort sort, Sort sort2, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("no groups to collect (groups.size() is 0)");
        }
        this.groupSort = sort;
        this.withinGroupSort = sort2;
        this.groups = collection;
        this.maxDocsPerGroup = n2;
        this.groupMap = new HashMap<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>>(collection.size());
        for (SearchGroup<GROUP_VALUE_TYPE> searchGroup : collection) {
            TopDocsCollector topDocsCollector = sort2 == null ? TopScoreDocCollector.create(n2) : TopFieldCollector.create(sort2, n2, bl3, bl, bl2);
            this.groupMap.put(searchGroup.groupValue, new SearchGroupDocs(searchGroup.groupValue, topDocsCollector));
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs : this.groupMap.values()) {
            searchGroupDocs.leafCollector.setScorer(scorer);
        }
    }

    @Override
    public void collect(int n2) throws IOException {
        ++this.totalHitCount;
        SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs = this.retrieveGroup(n2);
        if (searchGroupDocs != null) {
            ++this.totalGroupedHitCount;
            searchGroupDocs.leafCollector.collect(n2);
        }
    }

    protected abstract SearchGroupDocs<GROUP_VALUE_TYPE> retrieveGroup(int var1) throws IOException;

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs : this.groupMap.values()) {
            searchGroupDocs.leafCollector = searchGroupDocs.collector.getLeafCollector(leafReaderContext);
        }
    }

    public TopGroups<GROUP_VALUE_TYPE> getTopGroups(int n2) {
        GroupDocs[] groupDocsArray = new GroupDocs[this.groups.size()];
        int n3 = 0;
        float f2 = Float.MIN_VALUE;
        for (SearchGroup<GROUP_VALUE_TYPE> searchGroup : this.groups) {
            SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs = this.groupMap.get(searchGroup.groupValue);
            TopDocs topDocs = searchGroupDocs.collector.topDocs(n2, this.maxDocsPerGroup);
            groupDocsArray[n3++] = new GroupDocs(Float.NaN, topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, searchGroupDocs.groupValue, searchGroup.sortValues);
            f2 = Math.max(f2, topDocs.getMaxScore());
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort == null ? null : this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsArray, f2);
    }

    public class SearchGroupDocs<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public final TopDocsCollector<?> collector;
        public f leafCollector;

        public SearchGroupDocs(GROUP_VALUE_TYPE GROUP_VALUE_TYPE, TopDocsCollector<?> topDocsCollector) {
            this.groupValue = GROUP_VALUE_TYPE;
            this.collector = topDocsCollector;
        }
    }
}

