/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.grouping.a;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class TermAllGroupsCollector
extends a<BytesRef> {
    private final String groupField;
    private final SentinelIntSet ordSet;
    private final List<BytesRef> groups;
    private SortedDocValues index;

    public TermAllGroupsCollector(String string, int n2) {
        this.ordSet = new SentinelIntSet(n2, -2);
        this.groups = new ArrayList<BytesRef>(n2);
        this.groupField = string;
    }

    @Override
    public void collect(int n2) throws IOException {
        int n3 = this.index.getOrd(n2);
        if (!this.ordSet.exists(n3)) {
            this.ordSet.put(n3);
            BytesRef bytesRef = n3 == -1 ? null : BytesRef.deepCopyOf(this.index.lookupOrd(n3));
            this.groups.add(bytesRef);
        }
    }

    @Override
    public Collection<BytesRef> getGroups() {
        return this.groups;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        this.index = DocValues.getSorted(leafReaderContext.reader(), this.groupField);
        this.ordSet.clear();
        for (BytesRef bytesRef : this.groups) {
            if (bytesRef == null) {
                this.ordSet.put(-1);
                continue;
            }
            int n2 = this.index.lookupTerm(bytesRef);
            if (n2 < 0) continue;
            this.ordSet.put(n2);
        }
    }

    @Override
    public boolean needsScores() {
        return true;
    }
}

