/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.j;

public class DefaultSimilarity
extends TFIDFSimilarity {
    private static final float[] NORM_TABLE = new float[256];
    protected boolean discountOverlaps = true;

    @Override
    public float coord(int n2, int n3) {
        return (float)n2 / (float)n3;
    }

    @Override
    public float queryNorm(float f2) {
        return (float)(1.0 / Math.sqrt(f2));
    }

    @Override
    public final long encodeNormValue(float f2) {
        return j.a(f2);
    }

    @Override
    public final float decodeNormValue(long l2) {
        return NORM_TABLE[(int)(l2 & 0xFFL)];
    }

    @Override
    public float lengthNorm(FieldInvertState fieldInvertState) {
        int n2 = this.discountOverlaps ? fieldInvertState.getLength() - fieldInvertState.getNumOverlap() : fieldInvertState.getLength();
        return fieldInvertState.getBoost() * (float)(1.0 / Math.sqrt(n2));
    }

    @Override
    public float tf(float f2) {
        return (float)Math.sqrt(f2);
    }

    @Override
    public float sloppyFreq(int n2) {
        return 1.0f / (float)(n2 + 1);
    }

    @Override
    public float idf(long l2, long l3) {
        return (float)(Math.log((double)l3 / (double)(l2 + 1L)) + 1.0);
    }

    public String toString() {
        return "DefaultSimilarity";
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            DefaultSimilarity.NORM_TABLE[i2] = j.a((byte)i2);
        }
    }
}

