/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.util.zip.Checksum;

public class BufferedChecksum
implements Checksum {
    private final Checksum in;
    private final byte[] buffer;
    private int upto;

    public BufferedChecksum(Checksum checksum) {
        this(checksum, 256);
    }

    public BufferedChecksum(Checksum checksum, int n2) {
        this.in = checksum;
        this.buffer = new byte[n2];
    }

    @Override
    public void update(int n2) {
        if (this.upto == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.upto++] = (byte)n2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 >= this.buffer.length) {
            this.flush();
            this.in.update(byArray, n2, n3);
        } else {
            if (this.upto + n3 > this.buffer.length) {
                this.flush();
            }
            System.arraycopy(byArray, n2, this.buffer, this.upto, n3);
            this.upto += n3;
        }
    }

    @Override
    public long getValue() {
        this.flush();
        return this.in.getValue();
    }

    @Override
    public void reset() {
        this.upto = 0;
        this.in.reset();
    }

    private void flush() {
        if (this.upto > 0) {
            this.in.update(this.buffer, 0, this.upto);
        }
        this.upto = 0;
    }
}

