/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.h;

public abstract class BufferedIndexInput
extends IndexInput
implements h {
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;

    @Override
    public final byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public BufferedIndexInput(String string, IOContext iOContext) {
        this(string, BufferedIndexInput.bufferSize(iOContext));
    }

    public BufferedIndexInput(String string, int n2) {
        super(string);
        this.checkBufferSize(n2);
        this.bufferSize = n2;
    }

    public final void setBufferSize(int n2) {
        assert (this.buffer == null || this.bufferSize == this.buffer.length) : "buffer=" + this.buffer + " bufferSize=" + this.bufferSize + " buffer.length=" + (this.buffer != null ? this.buffer.length : 0);
        if (n2 != this.bufferSize) {
            this.checkBufferSize(n2);
            this.bufferSize = n2;
            if (this.buffer != null) {
                byte[] byArray = new byte[n2];
                int n3 = this.bufferLength - this.bufferPosition;
                int n4 = n3 > n2 ? n2 : n3;
                System.arraycopy(this.buffer, this.bufferPosition, byArray, 0, n4);
                this.bufferStart += (long)this.bufferPosition;
                this.bufferPosition = 0;
                this.bufferLength = n4;
                this.newBuffer(byArray);
            }
        }
    }

    protected void newBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int n2) {
        if (n2 < 8) {
            throw new IllegalArgumentException("bufferSize must be at least MIN_BUFFER_SIZE (got " + n2 + ")");
        }
    }

    @Override
    public final void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.readBytes(byArray, n2, n3, true);
    }

    @Override
    public final void readBytes(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        int n4 = this.bufferLength - this.bufferPosition;
        if (n3 <= n4) {
            if (n3 > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, byArray, n2, n3);
            }
            this.bufferPosition += n3;
        } else {
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
                this.bufferPosition += n4;
            }
            if (bl && n3 < this.bufferSize) {
                this.refill();
                if (this.bufferLength < n3) {
                    System.arraycopy(this.buffer, 0, byArray, n2, this.bufferLength);
                    throw new EOFException("read past EOF: " + this);
                }
                System.arraycopy(this.buffer, 0, byArray, n2, n3);
                this.bufferPosition = n3;
            } else {
                long l2 = this.bufferStart + (long)this.bufferPosition + (long)n3;
                if (l2 > this.length()) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.readInternal(byArray, n2, n3);
                this.bufferStart = l2;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    @Override
    public final short readShort() throws IOException {
        if (2 <= this.bufferLength - this.bufferPosition) {
            return (short)((this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF);
        }
        return super.readShort();
    }

    @Override
    public final int readInt() throws IOException {
        if (4 <= this.bufferLength - this.bufferPosition) {
            return (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
        }
        return super.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        if (8 <= this.bufferLength - this.bufferPosition) {
            int n2 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            int n3 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
        }
        return super.readLong();
    }

    @Override
    public final int readVInt() throws IOException {
        if (5 <= this.bufferLength - this.bufferPosition) {
            byte by;
            if ((by = this.buffer[this.bufferPosition++]) >= 0) {
                return by;
            }
            int n2 = by & 0x7F;
            by = this.buffer[this.bufferPosition++];
            n2 |= (by & 0x7F) << 7;
            if (by >= 0) {
                return n2;
            }
            by = this.buffer[this.bufferPosition++];
            n2 |= (by & 0x7F) << 14;
            if (by >= 0) {
                return n2;
            }
            by = this.buffer[this.bufferPosition++];
            n2 |= (by & 0x7F) << 21;
            if (by >= 0) {
                return n2;
            }
            by = this.buffer[this.bufferPosition++];
            n2 |= (by & 0xF) << 28;
            if ((by & 0xF0) == 0) {
                return n2;
            }
            throw new IOException("Invalid vInt detected (too many bits)");
        }
        return super.readVInt();
    }

    @Override
    public final long readVLong() throws IOException {
        if (9 <= this.bufferLength - this.bufferPosition) {
            byte by;
            if ((by = this.buffer[this.bufferPosition++]) >= 0) {
                return by;
            }
            long l2 = (long)by & 0x7FL;
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 7;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 14;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 21;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 28;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 35;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 42;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 49;
            if (by >= 0) {
                return l2;
            }
            by = this.buffer[this.bufferPosition++];
            l2 |= ((long)by & 0x7FL) << 56;
            if (by >= 0) {
                return l2;
            }
            throw new IOException("Invalid vLong detected (negative values disallowed)");
        }
        return super.readVLong();
    }

    @Override
    public final byte readByte(long l2) throws IOException {
        long l3 = l2 - this.bufferStart;
        if (l3 < 0L || l3 >= (long)this.bufferLength) {
            this.bufferStart = l2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l2);
            this.refill();
            l3 = 0L;
        }
        return this.buffer[(int)l3];
    }

    @Override
    public final short readShort(long l2) throws IOException {
        long l3 = l2 - this.bufferStart;
        if (l3 < 0L || l3 >= (long)(this.bufferLength - 1)) {
            this.bufferStart = l2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l2);
            this.refill();
            l3 = 0L;
        }
        return (short)((this.buffer[(int)l3] & 0xFF) << 8 | this.buffer[(int)l3 + 1] & 0xFF);
    }

    @Override
    public final int readInt(long l2) throws IOException {
        long l3 = l2 - this.bufferStart;
        if (l3 < 0L || l3 >= (long)(this.bufferLength - 3)) {
            this.bufferStart = l2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l2);
            this.refill();
            l3 = 0L;
        }
        return (this.buffer[(int)l3] & 0xFF) << 24 | (this.buffer[(int)l3 + 1] & 0xFF) << 16 | (this.buffer[(int)l3 + 2] & 0xFF) << 8 | this.buffer[(int)l3 + 3] & 0xFF;
    }

    @Override
    public final long readLong(long l2) throws IOException {
        long l3 = l2 - this.bufferStart;
        if (l3 < 0L || l3 >= (long)(this.bufferLength - 7)) {
            this.bufferStart = l2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l2);
            this.refill();
            l3 = 0L;
        }
        int n2 = (this.buffer[(int)l3] & 0xFF) << 24 | (this.buffer[(int)l3 + 1] & 0xFF) << 16 | (this.buffer[(int)l3 + 2] & 0xFF) << 8 | this.buffer[(int)l3 + 3] & 0xFF;
        int n3 = (this.buffer[(int)l3 + 4] & 0xFF) << 24 | (this.buffer[(int)l3 + 5] & 0xFF) << 16 | (this.buffer[(int)l3 + 6] & 0xFF) << 8 | this.buffer[(int)l3 + 7] & 0xFF;
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    private void refill() throws IOException {
        int n2;
        long l2 = this.bufferStart + (long)this.bufferPosition;
        long l3 = l2 + (long)this.bufferSize;
        if (l3 > this.length()) {
            l3 = this.length();
        }
        if ((n2 = (int)(l3 - l2)) <= 0) {
            throw new EOFException("read past EOF: " + this);
        }
        if (this.buffer == null) {
            this.newBuffer(new byte[this.bufferSize]);
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, n2);
        this.bufferLength = n2;
        this.bufferStart = l2;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public final long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public final void seek(long l2) throws IOException {
        if (l2 >= this.bufferStart && l2 < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(l2 - this.bufferStart);
        } else {
            this.bufferStart = l2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l2);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    @Override
    public BufferedIndexInput clone() {
        BufferedIndexInput bufferedIndexInput = (BufferedIndexInput)super.clone();
        bufferedIndexInput.buffer = null;
        bufferedIndexInput.bufferLength = 0;
        bufferedIndexInput.bufferPosition = 0;
        bufferedIndexInput.bufferStart = this.getFilePointer();
        return bufferedIndexInput;
    }

    @Override
    public IndexInput slice(String string, long l2, long l3) throws IOException {
        return BufferedIndexInput.wrap(string, this, l2, l3);
    }

    public static int bufferSize(IOContext iOContext) {
        switch (iOContext.context) {
            case MERGE: {
                return 4096;
            }
        }
        return 1024;
    }

    public static BufferedIndexInput wrap(String string, IndexInput indexInput, long l2, long l3) {
        return new SlicedIndexInput(string, indexInput, l2, l3);
    }

    private static final class SlicedIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        SlicedIndexInput(String string, IndexInput indexInput, long l2, long l3) {
            super(string == null ? indexInput.toString() : indexInput.toString() + " [slice=" + string + "]", 1024);
            if (l2 < 0L || l3 < 0L || l2 + l3 > indexInput.length()) {
                throw new IllegalArgumentException("slice() " + string + " out of bounds: " + indexInput);
            }
            this.base = indexInput.clone();
            this.fileOffset = l2;
            this.length = l3;
        }

        @Override
        public SlicedIndexInput clone() {
            SlicedIndexInput slicedIndexInput = (SlicedIndexInput)super.clone();
            slicedIndexInput.base = this.base.clone();
            slicedIndexInput.fileOffset = this.fileOffset;
            slicedIndexInput.length = this.length;
            return slicedIndexInput;
        }

        @Override
        protected void readInternal(byte[] byArray, int n2, int n3) throws IOException {
            long l2 = this.getFilePointer();
            if (l2 + (long)n3 > this.length) {
                throw new EOFException("read past EOF: " + this);
            }
            this.base.seek(this.fileOffset + l2);
            this.base.readBytes(byArray, n2, n3, false);
        }

        @Override
        protected void seekInternal(long l2) {
        }

        @Override
        public void close() throws IOException {
            this.base.close();
        }

        @Override
        public long length() {
            return this.length;
        }
    }
}

