/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] byArray, int n2, int n3) {
        this.reset(byArray, n2, n3);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] byArray) {
        this.reset(byArray, 0, byArray.length);
    }

    public void rewind() {
        this.pos = 0;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n2) {
        this.pos = n2;
    }

    public void reset(byte[] byArray, int n2, int n3) {
        this.bytes = byArray;
        this.pos = n2;
        this.limit = n2 + n3;
    }

    @Override
    public void skipBytes(long l2) {
        this.pos = (int)((long)this.pos + l2);
    }

    @Override
    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    @Override
    public int readInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        int n2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int n3 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    @Override
    public int readVInt() {
        byte by;
        if ((by = this.bytes[this.pos++]) >= 0) {
            return by;
        }
        int n2 = by & 0x7F;
        by = this.bytes[this.pos++];
        n2 |= (by & 0x7F) << 7;
        if (by >= 0) {
            return n2;
        }
        by = this.bytes[this.pos++];
        n2 |= (by & 0x7F) << 14;
        if (by >= 0) {
            return n2;
        }
        by = this.bytes[this.pos++];
        n2 |= (by & 0x7F) << 21;
        if (by >= 0) {
            return n2;
        }
        by = this.bytes[this.pos++];
        n2 |= (by & 0xF) << 28;
        if ((by & 0xF0) == 0) {
            return n2;
        }
        throw new RuntimeException("Invalid vInt detected (too many bits)");
    }

    @Override
    public long readVLong() {
        byte by;
        if ((by = this.bytes[this.pos++]) >= 0) {
            return by;
        }
        long l2 = (long)by & 0x7FL;
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 7;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 14;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 21;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 28;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 35;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 42;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 49;
        if (by >= 0) {
            return l2;
        }
        by = this.bytes[this.pos++];
        l2 |= ((long)by & 0x7FL) << 56;
        if (by >= 0) {
            return l2;
        }
        throw new RuntimeException("Invalid vLong detected (negative values disallowed)");
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.bytes, this.pos, byArray, n2, n3);
        this.pos += n3;
    }
}

