/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataOutput(byte[] byArray) {
        this.reset(byArray);
    }

    public ByteArrayDataOutput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] byArray) {
        this.reset(byArray, 0, byArray.length);
    }

    public void reset(byte[] byArray, int n2, int n3) {
        this.bytes = byArray;
        this.pos = n2;
        this.limit = n2 + n3;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void writeByte(byte by) {
        assert (this.pos < this.limit);
        this.bytes[this.pos++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) {
        assert (this.pos + n3 <= this.limit);
        System.arraycopy(byArray, n2, this.bytes, this.pos, n3);
        this.pos += n3;
    }
}

