/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.MergeInfo;

public class IOContext {
    public final Context context;
    public final MergeInfo mergeInfo;
    public final FlushInfo flushInfo;
    public final boolean readOnce;
    public static final IOContext DEFAULT = new IOContext(Context.DEFAULT);
    public static final IOContext READONCE = new IOContext(true);
    public static final IOContext READ = new IOContext(false);

    public IOContext() {
        this(false);
    }

    public IOContext(FlushInfo flushInfo) {
        assert (flushInfo != null);
        this.context = Context.FLUSH;
        this.mergeInfo = null;
        this.readOnce = false;
        this.flushInfo = flushInfo;
    }

    public IOContext(Context context) {
        this(context, null);
    }

    private IOContext(boolean bl) {
        this.context = Context.READ;
        this.mergeInfo = null;
        this.readOnce = bl;
        this.flushInfo = null;
    }

    public IOContext(MergeInfo mergeInfo) {
        this(Context.MERGE, mergeInfo);
    }

    private IOContext(Context context, MergeInfo mergeInfo) {
        assert (context != Context.MERGE || mergeInfo != null) : "MergeInfo must not be null if context is MERGE";
        assert (context != Context.FLUSH) : "Use IOContext(FlushInfo) to create a FLUSH IOContext";
        this.context = context;
        this.readOnce = false;
        this.mergeInfo = mergeInfo;
        this.flushInfo = null;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.context == null ? 0 : this.context.hashCode());
        n3 = 31 * n3 + (this.flushInfo == null ? 0 : this.flushInfo.hashCode());
        n3 = 31 * n3 + (this.mergeInfo == null ? 0 : this.mergeInfo.hashCode());
        n3 = 31 * n3 + (this.readOnce ? 1231 : 1237);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IOContext iOContext = (IOContext)object;
        if (this.context != iOContext.context) {
            return false;
        }
        if (this.flushInfo == null ? iOContext.flushInfo != null : !this.flushInfo.equals(iOContext.flushInfo)) {
            return false;
        }
        if (this.mergeInfo == null ? iOContext.mergeInfo != null : !this.mergeInfo.equals(iOContext.mergeInfo)) {
            return false;
        }
        return this.readOnce == iOContext.readOnce;
    }

    public String toString() {
        return "IOContext [context=" + (Object)((Object)this.context) + ", mergeInfo=" + this.mergeInfo + ", flushInfo=" + this.flushInfo + ", readOnce=" + this.readOnce + "]";
    }

    public static enum Context {
        MERGE,
        READ,
        FLUSH,
        DEFAULT;

    }
}

