/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.util.FileChannelUtils;
import org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.f;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = false;
    private boolean preload;
    public static final int DEFAULT_MAX_CHUNK_SIZE = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
    final int chunkSizePower;

    public MMapDirectory(Path path, f f2) throws IOException {
        this(path, f2, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path, f f2, int n2) throws IOException {
        super(path, f2);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(n2);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    @Override
    public IndexInput openInput(String string, IOContext iOContext) throws IOException {
        this.ensureOpen();
        Path path = this.directory.resolve(string);
        try (FileChannel fileChannel = FileChannelUtils.open(path, StandardOpenOption.READ);){
            String string2 = "MMapIndexInput(path=\"" + path.toString() + "\")";
            boolean bl = false;
            ByteBufferIndexInput byteBufferIndexInput = ByteBufferIndexInput.newInstance(string2, this.map(string2, fileChannel, 0L, fileChannel.size()), fileChannel.size(), this.chunkSizePower, null, false);
            return byteBufferIndexInput;
        }
    }

    final ByteBuffer[] map(String string, FileChannel fileChannel, long l2, long l3) throws IOException {
        if (l3 >>> this.chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + string);
        }
        long l4 = 1L << this.chunkSizePower;
        int n2 = (int)(l3 >>> this.chunkSizePower) + 1;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
        long l5 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            MappedByteBuffer mappedByteBuffer;
            int n3 = (int)(l3 > l5 + l4 ? l4 : l3 - l5);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l2 + l5, n3);
            }
            catch (IOException iOException) {
                throw this.convertMapFailedIOException(iOException, string, n3);
            }
            if (this.preload) {
                mappedByteBuffer.load();
            }
            byteBufferArray[i2] = mappedByteBuffer;
            l5 += (long)n3;
        }
        return byteBufferArray;
    }

    private IOException convertMapFailedIOException(IOException iOException, String string, int n2) {
        Throwable throwable;
        String string2;
        if (iOException.getCause() instanceof OutOfMemoryError) {
            string2 = "Map failed";
            throwable = null;
        } else {
            string2 = iOException.getMessage();
            throwable = iOException.getCause();
        }
        String string3 = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
        IOException iOException2 = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: http://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", string2, string, n2, string3), throwable);
        iOException2.setStackTrace(iOException.getStackTrace());
        return iOException2;
    }
}

