/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

public class MergeInfo {
    public final int totalMaxDoc;
    public final long estimatedMergeBytes;
    public final boolean isExternal;
    public final int mergeMaxNumSegments;

    public MergeInfo(int n2, long l2, boolean bl, int n3) {
        this.totalMaxDoc = n2;
        this.estimatedMergeBytes = l2;
        this.isExternal = bl;
        this.mergeMaxNumSegments = n3;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (int)(this.estimatedMergeBytes ^ this.estimatedMergeBytes >>> 32);
        n3 = 31 * n3 + (this.isExternal ? 1231 : 1237);
        n3 = 31 * n3 + this.mergeMaxNumSegments;
        n3 = 31 * n3 + this.totalMaxDoc;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MergeInfo mergeInfo = (MergeInfo)object;
        if (this.estimatedMergeBytes != mergeInfo.estimatedMergeBytes) {
            return false;
        }
        if (this.isExternal != mergeInfo.isExternal) {
            return false;
        }
        if (this.mergeMaxNumSegments != mergeInfo.mergeMaxNumSegments) {
            return false;
        }
        return this.totalMaxDoc == mergeInfo.totalMaxDoc;
    }

    public String toString() {
        return "MergeInfo [totalMaxDoc=" + this.totalMaxDoc + ", estimatedMergeBytes=" + this.estimatedMergeBytes + ", isExternal=" + this.isExternal + ", mergeMaxNumSegments=" + this.mergeMaxNumSegments + "]";
    }
}

