/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;

public class RAMOutputStream
extends IndexOutput
implements a {
    private final RAMFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;
    private final Checksum crc;

    public RAMOutputStream() {
        this("noname", new RAMFile(), false);
    }

    public RAMOutputStream(RAMFile rAMFile, boolean bl) {
        this("noname", rAMFile, bl);
    }

    public RAMOutputStream(String string, RAMFile rAMFile, boolean bl) {
        super("RAMOutputStream(name=\"" + string + "\")");
        this.file = rAMFile;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.crc = bl ? new BufferedChecksum(new CRC32()) : null;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        this.flush();
        long l2 = this.file.length;
        long l3 = 0L;
        int n2 = 0;
        while (l3 < l2) {
            int n3 = 1024;
            long l4 = l3 + (long)n3;
            if (l4 > l2) {
                n3 = (int)(l2 - l3);
            }
            dataOutput.writeBytes(this.file.getBuffer(n2++), n3);
            l3 = l4;
        }
    }

    public void writeTo(byte[] byArray, int n2) throws IOException {
        this.flush();
        long l2 = this.file.length;
        long l3 = 0L;
        int n3 = 0;
        int n4 = n2;
        while (l3 < l2) {
            int n5 = 1024;
            long l4 = l3 + (long)n5;
            if (l4 > l2) {
                n5 = (int)(l2 - l3);
            }
            System.arraycopy(this.file.getBuffer(n3++), 0, byArray, n4, n5);
            n4 += n5;
            l3 = l4;
        }
    }

    public void reset() {
        this.currentBuffer = null;
        this.currentBufferIndex = -1;
        this.bufferPosition = 0;
        this.bufferStart = 0L;
        this.bufferLength = 0;
        this.file.setLength(0L);
        if (this.crc != null) {
            this.crc.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void writeByte(byte by) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        if (this.crc != null) {
            this.crc.update(by);
        }
        this.currentBuffer[this.bufferPosition++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        assert (byArray != null);
        if (this.crc != null) {
            this.crc.update(byArray, n2, n3);
        }
        while (n3 > 0) {
            int n4;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int n5 = n3 < (n4 = this.currentBuffer.length - this.bufferPosition) ? n3 : n4;
            System.arraycopy(byArray, n2, this.currentBuffer, this.bufferPosition, n5);
            n2 += n5;
            n3 -= n5;
            this.bufferPosition += n5;
        }
    }

    private final void switchCurrentBuffer() {
        this.currentBuffer = this.currentBufferIndex == this.file.numBuffers() ? this.file.addBuffer(1024) : this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long l2 = this.bufferStart + (long)this.bufferPosition;
        if (l2 > this.file.length) {
            this.file.setLength(l2);
        }
    }

    protected void flush() throws IOException {
        this.setFileLength();
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public long ramBytesUsed() {
        return (long)this.file.numBuffers() * 1024L;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.singleton(b.a("file", this.file));
    }

    @Override
    public long getChecksum() throws IOException {
        if (this.crc == null) {
            throw new IllegalStateException("internal RAMOutputStream created with checksum disabled");
        }
        return this.crc.getValue();
    }
}

