/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.i;

public final class RateLimitedIndexOutput
extends IndexOutput {
    private final IndexOutput delegate;
    private final i rateLimiter;
    private long bytesSinceLastPause;
    private long currentMinPauseCheckBytes;

    public RateLimitedIndexOutput(i i2, IndexOutput indexOutput) {
        super("RateLimitedIndexOutput(" + indexOutput + ")");
        this.delegate = indexOutput;
        this.rateLimiter = i2;
        this.currentMinPauseCheckBytes = i2.getMinPauseCheckBytes();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long getFilePointer() {
        return this.delegate.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.delegate.getChecksum();
    }

    @Override
    public void writeByte(byte by) throws IOException {
        ++this.bytesSinceLastPause;
        this.checkRate();
        this.delegate.writeByte(by);
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.bytesSinceLastPause += (long)n3;
        this.checkRate();
        this.delegate.writeBytes(byArray, n2, n3);
    }

    private void checkRate() throws IOException {
        if (this.bytesSinceLastPause > this.currentMinPauseCheckBytes) {
            this.rateLimiter.pause(this.bytesSinceLastPause);
            this.bytesSinceLastPause = 0L;
            this.currentMinPauseCheckBytes = this.rateLimiter.getMinPauseCheckBytes();
        }
    }
}

