/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.store.f;
import org.apache.lucene.store.g;

public final class SingleInstanceLockFactory
extends f {
    final HashSet<String> locks = new HashSet();

    @Override
    public e obtainLock(c c2, String string) throws IOException {
        HashSet<String> hashSet = this.locks;
        synchronized (hashSet) {
            if (this.locks.add(string)) {
                return new SingleInstanceLock(string);
            }
            throw new g("lock instance already obtained: (dir=" + c2 + ", lockName=" + string + ")");
        }
    }

    private class SingleInstanceLock
    extends e {
        private final String lockName;
        private volatile boolean closed;

        public SingleInstanceLock(String string) {
            this.lockName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new a("Lock instance already released: " + this);
            }
            HashSet<String> hashSet = SingleInstanceLockFactory.this.locks;
            synchronized (hashSet) {
                if (!SingleInstanceLockFactory.this.locks.contains(this.lockName)) {
                    throw new a("Lock instance was invalidated from map: " + this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                HashSet<String> hashSet = SingleInstanceLockFactory.this.locks;
                synchronized (hashSet) {
                    if (!SingleInstanceLockFactory.this.locks.remove(this.lockName)) {
                        throw new a("Lock was already released: " + this);
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return super.toString() + ": " + this.lockName;
        }
    }
}

