/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;

public abstract class AttributeImpl
implements Cloneable,
c {
    public abstract void clear();

    public final String reflectAsString(final boolean bl) {
        final StringBuilder stringBuilder = new StringBuilder();
        this.reflectWith(new d(){

            @Override
            public void reflect(Class<? extends c> clazz, String string, Object object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                if (bl) {
                    stringBuilder.append(clazz.getName()).append('#');
                }
                stringBuilder.append(string).append('=').append(object == null ? "null" : object);
            }
        });
        return stringBuilder.toString();
    }

    public void reflectWith(d d2) {
        Field[] fieldArray;
        Class<?> clazz = this.getClass();
        Class<? extends c>[] classArray = AttributeSource.getAttributeInterfaces(clazz);
        if (classArray.length != 1) {
            throw new UnsupportedOperationException(clazz.getName() + " implements more than one Attribute interface, the default reflectWith() implementation cannot handle this.");
        }
        Class<? extends c> clazz2 = classArray[0];
        for (final Field field : fieldArray = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            d2.reflect(clazz2, field.getName(), AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        field.setAccessible(true);
                        return field.get(AttributeImpl.this);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException("Cannot access private fields.", illegalAccessException);
                    }
                }
            }));
        }
    }

    public abstract void copyTo(AttributeImpl var1);

    public AttributeImpl clone() {
        AttributeImpl attributeImpl = null;
        try {
            attributeImpl = (AttributeImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        return attributeImpl;
    }
}

