/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.lucene.portmobile.lang.ClassValue;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;

public class AttributeSource {
    private final Map<Class<? extends c>, AttributeImpl> attributes = new LinkedHashMap<Class<? extends c>, AttributeImpl>();
    private final Map<Class<? extends AttributeImpl>, AttributeImpl> attributeImpls = new LinkedHashMap<Class<? extends AttributeImpl>, AttributeImpl>();
    private final State[] currentState = new State[1];
    private final AttributeFactory factory;
    private static final ClassValue<Class<? extends c>[]> implInterfaces = new ClassValue<Class<? extends c>[]>(){

        protected Class<? extends c>[] a(Class<?> clazz) {
            LinkedHashSet<Class<c>> linkedHashSet = new LinkedHashSet<Class<c>>();
            do {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2 == c.class || !c.class.isAssignableFrom(clazz2)) continue;
                    linkedHashSet.add(clazz2.asSubclass(c.class));
                }
            } while ((clazz = clazz.getSuperclass()) != null);
            Class<?>[] classArray = linkedHashSet.toArray(new Class[linkedHashSet.size()]);
            return classArray;
        }

        @Override
        protected /* synthetic */ Object computeValue(Class clazz) {
            return this.a(clazz);
        }
    };

    public AttributeSource() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    public AttributeSource(AttributeFactory attributeFactory) {
        this.factory = attributeFactory;
    }

    static Class<? extends c>[] getAttributeInterfaces(Class<? extends AttributeImpl> clazz) {
        return implInterfaces.get(clazz);
    }

    public final void addAttributeImpl(AttributeImpl attributeImpl) {
        Class<?> clazz = attributeImpl.getClass();
        if (this.attributeImpls.containsKey(clazz)) {
            return;
        }
        for (Class<? extends c> clazz2 : AttributeSource.getAttributeInterfaces(clazz)) {
            if (this.attributes.containsKey(clazz2)) continue;
            this.currentState[0] = null;
            this.attributes.put(clazz2, attributeImpl);
            this.attributeImpls.put(clazz, attributeImpl);
        }
    }

    public final <T extends c> T addAttribute(Class<T> clazz) {
        AttributeImpl attributeImpl = this.attributes.get(clazz);
        if (attributeImpl == null) {
            if (!clazz.isInterface() || !c.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("addAttribute() only accepts an interface that extends Attribute, but " + clazz.getName() + " does not fulfil this contract.");
            }
            attributeImpl = this.factory.createAttributeInstance(clazz);
            this.addAttributeImpl(attributeImpl);
        }
        return (T)((c)clazz.cast(attributeImpl));
    }

    public final boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public final <T extends c> T getAttribute(Class<T> clazz) {
        return (T)((c)clazz.cast(this.attributes.get(clazz)));
    }

    private State getCurrentState() {
        State state = this.currentState[0];
        if (state != null || !this.hasAttributes()) {
            return state;
        }
        state = this.currentState[0] = new State();
        State state2 = this.currentState[0];
        Iterator<AttributeImpl> iterator = this.attributeImpls.values().iterator();
        state2.attribute = iterator.next();
        while (iterator.hasNext()) {
            state2 = state2.next = new State();
            state2.attribute = iterator.next();
        }
        return state;
    }

    public final void clearAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.clear();
            state = state.next;
        }
    }

    public int hashCode() {
        int n2 = 0;
        State state = this.getCurrentState();
        while (state != null) {
            n2 = n2 * 31 + state.attribute.hashCode();
            state = state.next;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AttributeSource) {
            AttributeSource attributeSource = (AttributeSource)object;
            if (this.hasAttributes()) {
                if (!attributeSource.hasAttributes()) {
                    return false;
                }
                if (this.attributeImpls.size() != attributeSource.attributeImpls.size()) {
                    return false;
                }
                State state = this.getCurrentState();
                State state2 = attributeSource.getCurrentState();
                while (state != null && state2 != null) {
                    if (state2.attribute.getClass() != state.attribute.getClass() || !state2.attribute.equals(state.attribute)) {
                        return false;
                    }
                    state = state.next;
                    state2 = state2.next;
                }
                return true;
            }
            return !attributeSource.hasAttributes();
        }
        return false;
    }

    public final String reflectAsString(final boolean bl) {
        final StringBuilder stringBuilder = new StringBuilder();
        this.reflectWith(new d(){

            @Override
            public void reflect(Class<? extends c> clazz, String string, Object object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                if (bl) {
                    stringBuilder.append(clazz.getName()).append('#');
                }
                stringBuilder.append(string).append('=').append(object == null ? "null" : object);
            }
        });
        return stringBuilder.toString();
    }

    public final void reflectWith(d d2) {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.reflectWith(d2);
            state = state.next;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " " + this.reflectAsString(false);
    }

    public static final class State
    implements Cloneable {
        AttributeImpl attribute;
        State next;

        public State clone() {
            State state = new State();
            state.attribute = this.attribute.clone();
            if (this.next != null) {
                state.next = this.next.clone();
            }
            return state;
        }
    }
}

