/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.RamUsageEstimator;

public class BitDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitDocIdSet.class);
    private final BitSet set;
    private final long cost;

    public BitDocIdSet(BitSet bitSet, long l2) {
        this.set = bitSet;
        this.cost = l2;
    }

    public BitDocIdSet(BitSet bitSet) {
        this(bitSet, bitSet.approximateCardinality());
    }

    @Override
    public DocIdSetIterator iterator() {
        return new BitSetIterator(this.set, this.cost);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.set.ramBytesUsed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(set=" + this.set + ",cost=" + this.cost + ")";
    }
}

