/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;

public final class ByteBlockPool {
    public byte[][] buffers = new byte[10][];
    private int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;
    public static final int[] NEXT_LEVEL_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    public static final int[] LEVEL_SIZE_ARRAY = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    public static final int FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void reset(boolean bl, boolean bl2) {
        if (this.bufferUpto != -1) {
            int n2;
            if (bl) {
                for (n2 = 0; n2 < this.bufferUpto; ++n2) {
                    Arrays.fill(this.buffers[n2], (byte)0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            }
            if (this.bufferUpto > 0 || !bl2) {
                n2 = bl2 ? 1 : 0;
                this.allocator.recycleByteBlocks(this.buffers, n2, 1 + this.bufferUpto);
                Arrays.fill((Object[])this.buffers, n2, 1 + this.bufferUpto, null);
            }
            if (bl2) {
                this.bufferUpto = 0;
                this.byteUpto = 0;
                this.byteOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.byteUpto = 32768;
                this.byteOffset = Short.MIN_VALUE;
                this.buffer = null;
            }
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] byArrayArray = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, byArrayArray, 0, this.buffers.length);
            this.buffers = byArrayArray;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset += 32768;
    }

    public int newSlice(int n2) {
        if (this.byteUpto > 32768 - n2) {
            this.nextBuffer();
        }
        int n3 = this.byteUpto;
        this.byteUpto += n2;
        this.buffer[this.byteUpto - 1] = 16;
        return n3;
    }

    public int allocSlice(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xF;
        int n4 = NEXT_LEVEL_ARRAY[n3];
        int n5 = LEVEL_SIZE_ARRAY[n4];
        if (this.byteUpto > 32768 - n5) {
            this.nextBuffer();
        }
        int n6 = this.byteUpto;
        int n7 = n6 + this.byteOffset;
        this.byteUpto += n5;
        this.buffer[n6] = byArray[n2 - 3];
        this.buffer[n6 + 1] = byArray[n2 - 2];
        this.buffer[n6 + 2] = byArray[n2 - 1];
        byArray[n2 - 3] = (byte)(n7 >>> 24);
        byArray[n2 - 2] = (byte)(n7 >>> 16);
        byArray[n2 - 1] = (byte)(n7 >>> 8);
        byArray[n2] = (byte)n7;
        this.buffer[this.byteUpto - 1] = (byte)(0x10 | n4);
        return n6 + 3;
    }

    public void setBytesRef(BytesRef bytesRef, int n2) {
        bytesRef.bytes = this.buffers[n2 >> 15];
        byte[] byArray = bytesRef.bytes;
        int n3 = n2 & Short.MAX_VALUE;
        if ((byArray[n3] & 0x80) == 0) {
            bytesRef.length = byArray[n3];
            bytesRef.offset = n3 + 1;
        } else {
            bytesRef.length = (byArray[n3] & 0x7F) + ((byArray[n3 + 1] & 0xFF) << 7);
            bytesRef.offset = n3 + 2;
        }
        assert (bytesRef.length >= 0);
    }

    public static class DirectTrackingAllocator
    extends Allocator {
        private final Counter bytesUsed;

        public DirectTrackingAllocator(Counter counter) {
            this(32768, counter);
        }

        public DirectTrackingAllocator(int n2, Counter counter) {
            super(n2);
            this.bytesUsed = counter;
        }

        @Override
        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }

        @Override
        public void recycleByteBlocks(byte[][] byArray, int n2, int n3) {
            this.bytesUsed.addAndGet(-((n3 - n2) * this.blockSize));
            for (int i2 = n2; i2 < n3; ++i2) {
                byArray[i2] = null;
            }
        }
    }

    public static final class a
    extends Allocator {
        public a() {
            this(32768);
        }

        public a(int n2) {
            super(n2);
        }

        @Override
        public void recycleByteBlocks(byte[][] byArray, int n2, int n3) {
        }
    }

    public static abstract class Allocator {
        protected final int blockSize;

        public Allocator(int n2) {
            this.blockSize = n2;
        }

        public abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }
}

