/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.f;

public final class BytesRefHash {
    final ByteBlockPool pool;
    int[] bytesStart;
    private final BytesRef scratch1 = new BytesRef();
    private int hashSize;
    private int hashHalfSize;
    private int hashMask;
    private int count;
    private int lastCount = -1;
    private int[] ids;
    private final a bytesStartArray;
    private Counter bytesUsed;

    public BytesRefHash() {
        this(new ByteBlockPool(new ByteBlockPool.a()));
    }

    public BytesRefHash(ByteBlockPool byteBlockPool) {
        this(byteBlockPool, 16, new DirectBytesStartArray(16));
    }

    public BytesRefHash(ByteBlockPool byteBlockPool, int n2, a a2) {
        this.hashSize = n2;
        this.hashHalfSize = this.hashSize >> 1;
        this.hashMask = this.hashSize - 1;
        this.pool = byteBlockPool;
        this.ids = new int[this.hashSize];
        Arrays.fill(this.ids, -1);
        this.bytesStartArray = a2;
        this.bytesStart = a2.init();
        this.bytesUsed = a2.bytesUsed() == null ? Counter.newCounter() : a2.bytesUsed();
        this.bytesUsed.addAndGet(this.hashSize * 4);
    }

    public int size() {
        return this.count;
    }

    public BytesRef get(int n2, BytesRef bytesRef) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (n2 < this.bytesStart.length) : "bytesID exceeds byteStart len: " + this.bytesStart.length;
        this.pool.setBytesRef(bytesRef, this.bytesStart[n2]);
        return bytesRef;
    }

    int[] compact() {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int n2 = 0;
        for (int i2 = 0; i2 < this.hashSize; ++i2) {
            if (this.ids[i2] == -1) continue;
            if (n2 < i2) {
                this.ids[n2] = this.ids[i2];
                this.ids[i2] = -1;
            }
            ++n2;
        }
        assert (n2 == this.count);
        this.lastCount = this.count;
        return this.ids;
    }

    public int[] sort(final Comparator<BytesRef> comparator) {
        final int[] nArray = this.compact();
        new f(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            @Override
            protected void swap(int n2, int n3) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
            }

            @Override
            protected int compare(int n2, int n3) {
                int n4 = nArray[n2];
                int n5 = nArray[n3];
                assert (BytesRefHash.this.bytesStart.length > n4 && BytesRefHash.this.bytesStart.length > n5);
                BytesRefHash.this.pool.setBytesRef(this.scratch1, BytesRefHash.this.bytesStart[n4]);
                BytesRefHash.this.pool.setBytesRef(this.scratch2, BytesRefHash.this.bytesStart[n5]);
                return comparator.compare(this.scratch1, this.scratch2);
            }

            @Override
            protected void setPivot(int n2) {
                int n3 = nArray[n2];
                assert (BytesRefHash.this.bytesStart.length > n3);
                BytesRefHash.this.pool.setBytesRef(this.pivot, BytesRefHash.this.bytesStart[n3]);
            }

            @Override
            protected int comparePivot(int n2) {
                int n3 = nArray[n2];
                assert (BytesRefHash.this.bytesStart.length > n3);
                BytesRefHash.this.pool.setBytesRef(this.scratch2, BytesRefHash.this.bytesStart[n3]);
                return comparator.compare(this.pivot, this.scratch2);
            }
        }.sort(0, this.count);
        return nArray;
    }

    private boolean equals(int n2, BytesRef bytesRef) {
        this.pool.setBytesRef(this.scratch1, this.bytesStart[n2]);
        return this.scratch1.bytesEquals(bytesRef);
    }

    private boolean shrink(int n2) {
        int n3;
        for (n3 = this.hashSize; n3 >= 8 && n3 / 4 > n2; n3 /= 2) {
        }
        if (n3 != this.hashSize) {
            this.bytesUsed.addAndGet(4 * -(this.hashSize - n3));
            this.hashSize = n3;
            this.ids = new int[this.hashSize];
            Arrays.fill(this.ids, -1);
            this.hashHalfSize = n3 / 2;
            this.hashMask = n3 - 1;
            return true;
        }
        return false;
    }

    public void clear(boolean bl) {
        this.lastCount = this.count;
        this.count = 0;
        if (bl) {
            this.pool.reset(false, false);
        }
        this.bytesStart = this.bytesStartArray.clear();
        if (this.lastCount != -1 && this.shrink(this.lastCount)) {
            return;
        }
        Arrays.fill(this.ids, -1);
    }

    public int add(BytesRef bytesRef) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int n2 = bytesRef.length;
        int n3 = this.findHash(bytesRef);
        int n4 = this.ids[n3];
        if (n4 == -1) {
            int n5 = 2 + bytesRef.length;
            if (n5 + this.pool.byteUpto > 32768) {
                if (n5 > 32768) {
                    throw new b("bytes can be at most 32766 in length; got " + bytesRef.length);
                }
                this.pool.nextBuffer();
            }
            byte[] byArray = this.pool.buffer;
            int n6 = this.pool.byteUpto;
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            n4 = this.count++;
            this.bytesStart[n4] = n6 + this.pool.byteOffset;
            if (n2 < 128) {
                byArray[n6] = (byte)n2;
                this.pool.byteUpto += n2 + 1;
                assert (n2 >= 0) : "Length must be positive: " + n2;
                System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, n6 + 1, n2);
            } else {
                byArray[n6] = (byte)(0x80 | n2 & 0x7F);
                byArray[n6 + 1] = (byte)(n2 >> 7 & 0xFF);
                this.pool.byteUpto += n2 + 2;
                System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, n6 + 2, n2);
            }
            assert (this.ids[n3] == -1);
            this.ids[n3] = n4;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, true);
            }
            return n4;
        }
        return -(n4 + 1);
    }

    private int findHash(BytesRef bytesRef) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int n2 = this.doHash(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        int n3 = n2 & this.hashMask;
        int n4 = this.ids[n3];
        if (n4 != -1 && !this.equals(n4, bytesRef)) {
            while ((n4 = this.ids[n3 = ++n2 & this.hashMask]) != -1 && !this.equals(n4, bytesRef)) {
            }
        }
        return n3;
    }

    public int addByPoolOffset(int n2) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int n3 = n2;
        int n4 = n2 & this.hashMask;
        int n5 = this.ids[n4];
        if (n5 != -1 && this.bytesStart[n5] != n2) {
            while ((n5 = this.ids[n4 = ++n3 & this.hashMask]) != -1 && this.bytesStart[n5] != n2) {
            }
        }
        if (n5 == -1) {
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            n5 = this.count++;
            this.bytesStart[n5] = n2;
            assert (this.ids[n4] == -1);
            this.ids[n4] = n5;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, false);
            }
            return n5;
        }
        return -(n5 + 1);
    }

    private void rehash(int n2, boolean bl) {
        int n3 = n2 - 1;
        this.bytesUsed.addAndGet(4 * n2);
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        for (int i2 = 0; i2 < this.hashSize; ++i2) {
            int n4;
            int n5;
            int n6 = this.ids[i2];
            if (n6 == -1) continue;
            if (bl) {
                int n7;
                int n8;
                n5 = this.bytesStart[n6];
                byte[] byArray = this.pool.buffers[n5 >> 15];
                int n9 = n5 & Short.MAX_VALUE;
                if ((byArray[n9] & 0x80) == 0) {
                    n8 = byArray[n9];
                    n7 = n9 + 1;
                } else {
                    n8 = (byArray[n9] & 0x7F) + ((byArray[n9 + 1] & 0xFF) << 7);
                    n7 = n9 + 2;
                }
                n4 = this.doHash(byArray, n7, n8);
            } else {
                n4 = this.bytesStart[n6];
            }
            n5 = n4 & n3;
            assert (n5 >= 0);
            if (nArray[n5] != -1) {
                while (nArray[n5 = ++n4 & n3] != -1) {
                }
            }
            nArray[n5] = n6;
        }
        this.hashMask = n3;
        this.bytesUsed.addAndGet(4 * -this.ids.length);
        this.ids = nArray;
        this.hashSize = n2;
        this.hashHalfSize = n2 / 2;
    }

    private int doHash(byte[] byArray, int n2, int n3) {
        return StringHelper.murmurhash3_x86_32(byArray, n2, n3, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public void reinit() {
        if (this.bytesStart == null) {
            this.bytesStart = this.bytesStartArray.init();
        }
        if (this.ids == null) {
            this.ids = new int[this.hashSize];
            this.bytesUsed.addAndGet(4 * this.hashSize);
        }
    }

    public int byteStart(int n2) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (n2 >= 0 && n2 < this.count) : n2;
        return this.bytesStart[n2];
    }

    public static class DirectBytesStartArray
    extends a {
        protected final int initSize;
        private int[] bytesStart;
        private final Counter bytesUsed;

        public DirectBytesStartArray(int n2, Counter counter) {
            this.bytesUsed = counter;
            this.initSize = n2;
        }

        public DirectBytesStartArray(int n2) {
            this(n2, Counter.newCounter());
        }

        @Override
        public int[] clear() {
            this.bytesStart = null;
            return null;
        }

        @Override
        public int[] grow() {
            assert (this.bytesStart != null);
            this.bytesStart = ArrayUtil.grow(this.bytesStart, this.bytesStart.length + 1);
            return this.bytesStart;
        }

        @Override
        public int[] init() {
            this.bytesStart = new int[ArrayUtil.oversize(this.initSize, 4)];
            return this.bytesStart;
        }

        @Override
        public Counter bytesUsed() {
            return this.bytesUsed;
        }
    }

    public static abstract class a {
        public abstract int[] init();

        public abstract int[] grow();

        public abstract int[] clear();

        public abstract Counter bytesUsed();
    }

    public static class b
    extends RuntimeException {
        b(String string) {
            super(string);
        }
    }
}

