/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.StringTokenizer;
import org.apache.lucene.util.Version;

public final class Constants {
    public static final String JVM_VENDOR = System.getProperty("java.vm.vendor");
    public static final String JVM_VERSION = System.getProperty("java.vm.version");
    public static final String JVM_NAME = System.getProperty("java.vm.name");
    public static final String JVM_SPEC_VERSION = System.getProperty("java.specification.version");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean LINUX = OS_NAME.startsWith("Linux");
    public static final boolean WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean SUN_OS = OS_NAME.startsWith("SunOS");
    public static final boolean MAC_OS_X = OS_NAME.startsWith("Mac OS X");
    public static final boolean FREE_BSD = OS_NAME.startsWith("FreeBSD");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    private static final int JVM_MAJOR_VERSION;
    private static final int JVM_MINOR_VERSION;
    public static final boolean JRE_IS_64BIT;
    public static final boolean JRE_IS_MINIMUM_JAVA8;
    public static final boolean JRE_IS_MINIMUM_JAVA9;
    @Deprecated
    public static final String LUCENE_MAIN_VERSION;
    @Deprecated
    public static final String LUCENE_VERSION;

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(JVM_SPEC_VERSION, ".");
        JVM_MAJOR_VERSION = Integer.parseInt(stringTokenizer.nextToken());
        JVM_MINOR_VERSION = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
        boolean bl = false;
        String string = System.getProperty("sun.arch.data.model");
        bl = string != null ? string.contains("64") : OS_ARCH != null && OS_ARCH.contains("64");
        JRE_IS_64BIT = bl;
        JRE_IS_MINIMUM_JAVA8 = JVM_MAJOR_VERSION > 1 || JVM_MAJOR_VERSION == 1 && JVM_MINOR_VERSION >= 8;
        JRE_IS_MINIMUM_JAVA9 = JVM_MAJOR_VERSION > 1 || JVM_MAJOR_VERSION == 1 && JVM_MINOR_VERSION >= 9;
        LUCENE_MAIN_VERSION = Version.LATEST.toString();
        LUCENE_VERSION = Version.LATEST.toString();
    }
}

