/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;

public final class FrequencyTrackingRingBuffer
implements a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FrequencyTrackingRingBuffer.class);
    private final int maxSize;
    private final int[] buffer;
    private int position;
    private final IntBag frequencies;

    public FrequencyTrackingRingBuffer(int n2, int n3) {
        if (n2 < 2) {
            throw new IllegalArgumentException("maxSize must be at least 2");
        }
        this.maxSize = n2;
        this.buffer = new int[n2];
        this.position = 0;
        this.frequencies = new IntBag(n2);
        Arrays.fill(this.buffer, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.frequencies.add(n3);
        }
        assert (this.frequencies.frequency(n3) == n2);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.frequencies.ramBytesUsed() + RamUsageEstimator.sizeOf(this.buffer);
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    private static class IntBag
    implements a {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntBag.class);
        private final int[] keys;
        private final int[] freqs;
        private final int mask;

        IntBag(int n2) {
            int n3 = Math.max(2, n2 * 3 / 2);
            n3 = Integer.highestOneBit(n3 - 1) << 1;
            assert (n3 > n2);
            this.keys = new int[n3];
            this.freqs = new int[n3];
            this.mask = n3 - 1;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + RamUsageEstimator.sizeOf(this.freqs);
        }

        @Override
        public Collection<a> getChildResources() {
            return Collections.emptyList();
        }

        int frequency(int n2) {
            int n3 = n2 & this.mask;
            while (this.keys[n3] != n2) {
                if (this.freqs[n3] == 0) {
                    return 0;
                }
                n3 = n3 + 1 & this.mask;
            }
            return this.freqs[n3];
        }

        int add(int n2) {
            int n3 = n2 & this.mask;
            while (true) {
                if (this.freqs[n3] == 0) {
                    this.keys[n3] = n2;
                    this.freqs[n3] = 1;
                    return 1;
                }
                if (this.keys[n3] == n2) {
                    int n4 = n3;
                    int n5 = this.freqs[n4] + 1;
                    this.freqs[n4] = n5;
                    return n5;
                }
                n3 = n3 + 1 & this.mask;
            }
        }
    }
}

