/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.RamUsageEstimator;

final class IntArrayDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayDocIdSet.class);
    private final int[] docs;
    private final int length;

    IntArrayDocIdSet(int[] nArray, int n2) {
        if (nArray[n2] != Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.docs = nArray;
        this.length = n2;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.docs);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new IntArrayDocIdSetIterator(this.docs, this.length);
    }

    static class IntArrayDocIdSetIterator
    extends DocIdSetIterator {
        private final int[] docs;
        private final int length;
        private int i = -1;
        private int doc = -1;

        IntArrayDocIdSetIterator(int[] nArray, int n2) {
            this.docs = nArray;
            this.length = n2;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.docs[++this.i];
            return this.doc;
        }

        @Override
        public int advance(int n2) throws IOException {
            this.i = Arrays.binarySearch(this.docs, this.i + 1, this.length, n2);
            if (this.i < 0) {
                this.i = -1 - this.i;
            }
            this.doc = this.docs[this.i];
            return this.doc;
        }

        @Override
        public long cost() {
            return this.length;
        }
    }
}

