/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;

public abstract class PriorityQueue<T> {
    private int size = 0;
    private final int maxSize;
    private final T[] heap;

    public PriorityQueue(int n2) {
        this(n2, true);
    }

    public PriorityQueue(int n2, boolean bl) {
        T t2;
        int n3;
        if (0 == n2) {
            n3 = 2;
        } else {
            n3 = n2 + 1;
            if (n3 > ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be <= " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + n2);
            }
        }
        Object[] objectArray = new Object[n3];
        this.heap = objectArray;
        this.maxSize = n2;
        if (bl && (t2 = this.getSentinelObject()) != null) {
            this.heap[1] = t2;
            for (int i2 = 2; i2 < this.heap.length; ++i2) {
                this.heap[i2] = this.getSentinelObject();
            }
            this.size = n2;
        }
    }

    protected abstract boolean lessThan(T var1, T var2);

    protected T getSentinelObject() {
        return null;
    }

    public final T add(T t2) {
        ++this.size;
        this.heap[this.size] = t2;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public T insertWithOverflow(T t2) {
        if (this.size < this.maxSize) {
            this.add(t2);
            return null;
        }
        if (this.size > 0 && !this.lessThan(t2, this.heap[1])) {
            T t3 = this.heap[1];
            this.heap[1] = t2;
            this.updateTop();
            return t3;
        }
        return t2;
    }

    public final T top() {
        return this.heap[1];
    }

    public final T pop() {
        if (this.size > 0) {
            T t2 = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap(1);
            return t2;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap(1);
        return this.heap[1];
    }

    public final T updateTop(T t2) {
        this.heap[1] = t2;
        return this.updateTop();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i2 = 0; i2 <= this.size; ++i2) {
            this.heap[i2] = null;
        }
        this.size = 0;
    }

    private final boolean upHeap(int n2) {
        int n3 = n2;
        T t2 = this.heap[n3];
        for (int i2 = n3 >>> 1; i2 > 0 && this.lessThan(t2, this.heap[i2]); i2 >>>= 1) {
            this.heap[n3] = this.heap[i2];
            n3 = i2;
        }
        this.heap[n3] = t2;
        return n3 != n2;
    }

    private final void downHeap(int n2) {
        T t2 = this.heap[n2];
        int n3 = n2 << 1;
        int n4 = n3 + 1;
        if (n4 <= this.size && this.lessThan(this.heap[n4], this.heap[n3])) {
            n3 = n4;
        }
        while (n3 <= this.size && this.lessThan(this.heap[n3], t2)) {
            this.heap[n2] = this.heap[n3];
            n2 = n3;
            n4 = (n3 = n2 << 1) + 1;
            if (n4 > this.size || !this.lessThan(this.heap[n4], this.heap[n3])) continue;
            n3 = n4;
        }
        this.heap[n2] = t2;
    }

    protected final Object[] getHeapArray() {
        return this.heap;
    }
}

