/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Sorter;

public abstract class TimSorter
extends Sorter {
    final int maxTempSlots;
    int minRun;
    int to;
    int stackSize;
    int[] runEnds = new int[50];

    protected TimSorter(int n2) {
        this.maxTempSlots = n2;
    }

    static int minRun(int n2) {
        int n3;
        assert (n2 >= 32);
        int n4 = 0;
        for (n3 = n2; n3 >= 64; n3 >>>= 1) {
            n4 |= n3 & 1;
        }
        int n5 = n3 + n4;
        assert (n5 >= 32 && n5 <= 64);
        return n5;
    }

    int runLen(int n2) {
        int n3 = this.stackSize - n2;
        return this.runEnds[n3] - this.runEnds[n3 - 1];
    }

    int runBase(int n2) {
        return this.runEnds[this.stackSize - n2 - 1];
    }

    int runEnd(int n2) {
        return this.runEnds[this.stackSize - n2];
    }

    void setRunEnd(int n2, int n3) {
        this.runEnds[this.stackSize - n2] = n3;
    }

    void pushRunLen(int n2) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + n2;
        ++this.stackSize;
    }

    int nextRun() {
        int n2;
        int n3 = this.runEnd(0);
        assert (n3 < this.to);
        if (n3 == this.to - 1) {
            return 1;
        }
        if (this.compare(n3, n3 + 1) > 0) {
            for (n2 = n3 + 2; n2 < this.to && this.compare(n2 - 1, n2) > 0; ++n2) {
            }
            this.reverse(n3, n2);
        } else {
            while (n2 < this.to && this.compare(n2 - 1, n2) <= 0) {
                ++n2;
            }
        }
        int n4 = Math.max(n2, Math.min(this.to, n3 + this.minRun));
        this.binarySort(n3, n4, n2);
        return n4 - n3;
    }

    void ensureInvariants() {
        while (this.stackSize > 1) {
            int n2;
            int n3 = this.runLen(0);
            int n4 = this.runLen(1);
            if (this.stackSize > 2 && (n2 = this.runLen(2)) <= n4 + n3) {
                if (n2 < n3) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (n4 > n3) break;
            this.mergeAt(0);
        }
    }

    void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    void reset(int n2, int n3) {
        this.stackSize = 0;
        Arrays.fill(this.runEnds, 0);
        this.runEnds[0] = n2;
        this.to = n3;
        int n4 = n3 - n2;
        this.minRun = n4 <= 64 ? n4 : TimSorter.minRun(n4);
    }

    void mergeAt(int n2) {
        assert (this.stackSize >= 2);
        this.merge(this.runBase(n2 + 1), this.runBase(n2), this.runEnd(n2));
        for (int i2 = n2 + 1; i2 > 0; --i2) {
            this.setRunEnd(i2, this.runEnd(i2 - 1));
        }
        --this.stackSize;
    }

    void merge(int n2, int n3, int n4) {
        if (this.compare(n3 - 1, n3) <= 0) {
            return;
        }
        n2 = this.upper2(n2, n3, n3);
        if ((n4 = this.lower2(n3, n4, n3 - 1)) - n3 <= n3 - n2 && n4 - n3 <= this.maxTempSlots) {
            this.mergeHi(n2, n3, n4);
        } else if (n3 - n2 <= this.maxTempSlots) {
            this.mergeLo(n2, n3, n4);
        } else {
            this.mergeInPlace(n2, n3, n4);
        }
    }

    @Override
    public void sort(int n2, int n3) {
        this.checkRange(n2, n3);
        if (n3 - n2 <= 1) {
            return;
        }
        this.reset(n2, n3);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < n3);
        this.exhaustStack();
        assert (this.runEnd(0) == n3);
    }

    @Override
    void doRotate(int n2, int n3, int n4) {
        int n5 = n3 - n2;
        int n6 = n4 - n3;
        if (n5 == n6) {
            while (n3 < n4) {
                this.swap(n2++, n3++);
            }
        } else if (n6 < n5 && n6 <= this.maxTempSlots) {
            this.save(n3, n6);
            int n7 = n2 + n5 - 1;
            int n8 = n4 - 1;
            while (n7 >= n2) {
                this.copy(n7, n8);
                --n7;
                --n8;
            }
            n7 = 0;
            n8 = n2;
            while (n7 < n6) {
                this.restore(n7, n8);
                ++n7;
                ++n8;
            }
        } else if (n5 <= this.maxTempSlots) {
            this.save(n2, n5);
            int n9 = n3;
            int n10 = n2;
            while (n9 < n4) {
                this.copy(n9, n10);
                ++n9;
                ++n10;
            }
            n9 = 0;
            for (n10 = n2 + n6; n10 < n4; ++n10) {
                this.restore(n9, n10);
                ++n9;
            }
        } else {
            this.reverse(n2, n3);
            this.reverse(n3, n4);
            this.reverse(n2, n4);
        }
    }

    void mergeLo(int n2, int n3, int n4) {
        assert (this.compare(n2, n3) > 0);
        int n5 = n3 - n2;
        this.save(n2, n5);
        this.copy(n3, n2);
        int n6 = 0;
        int n7 = n3 + 1;
        int n8 = n2 + 1;
        block0: while (true) {
            int n9 = 0;
            while (n9 < 7) {
                if (n6 >= n5 || n7 >= n4) break block0;
                if (this.compareSaved(n6, n7) <= 0) {
                    this.restore(n6++, n8++);
                    n9 = 0;
                    continue;
                }
                this.copy(n7++, n8++);
                ++n9;
            }
            n9 = this.lowerSaved3(n7, n4, n6);
            while (n7 < n9) {
                this.copy(n7++, n8);
                ++n8;
            }
            this.restore(n6++, n8++);
        }
        while (n6 < n5) {
            this.restore(n6++, n8);
            ++n8;
        }
        assert (n7 == n8);
    }

    void mergeHi(int n2, int n3, int n4) {
        assert (this.compare(n3 - 1, n4 - 1) > 0);
        int n5 = n4 - n3;
        this.save(n3, n5);
        this.copy(n3 - 1, n4 - 1);
        int n6 = n3 - 2;
        int n7 = n5 - 1;
        int n8 = n4 - 2;
        block0: while (true) {
            int n9 = 0;
            while (n9 < 7) {
                if (n6 < n2 || n7 < 0) break block0;
                if (this.compareSaved(n7, n6) >= 0) {
                    this.restore(n7--, n8--);
                    n9 = 0;
                    continue;
                }
                this.copy(n6--, n8--);
                ++n9;
            }
            n9 = this.upperSaved3(n2, n6 + 1, n7);
            while (n6 >= n9) {
                this.copy(n6--, n8--);
            }
            this.restore(n7--, n8--);
        }
        while (n7 >= 0) {
            this.restore(n7--, n8);
            --n8;
        }
        assert (n6 == n8);
    }

    int lowerSaved(int n2, int n3, int n4) {
        int n5 = n3 - n2;
        while (n5 > 0) {
            int n6 = n5 >>> 1;
            int n7 = n2 + n6;
            if (this.compareSaved(n4, n7) > 0) {
                n2 = n7 + 1;
                n5 = n5 - n6 - 1;
                continue;
            }
            n5 = n6;
        }
        return n2;
    }

    int upperSaved(int n2, int n3, int n4) {
        int n5 = n3 - n2;
        while (n5 > 0) {
            int n6 = n5 >>> 1;
            int n7 = n2 + n6;
            if (this.compareSaved(n4, n7) < 0) {
                n5 = n6;
                continue;
            }
            n2 = n7 + 1;
            n5 = n5 - n6 - 1;
        }
        return n2;
    }

    int lowerSaved3(int n2, int n3, int n4) {
        int n5;
        int n6 = n2;
        for (int i2 = n6 + 1; i2 < n3; i2 += n5 << 1) {
            if (this.compareSaved(n4, i2) <= 0) {
                return this.lowerSaved(n6, i2, n4);
            }
            n5 = i2 - n6;
            n6 = i2;
        }
        return this.lowerSaved(n6, n3, n4);
    }

    int upperSaved3(int n2, int n3, int n4) {
        int n5;
        int n6 = n3;
        for (int i2 = n3 - 1; i2 > n2; i2 -= n5 << 1) {
            if (this.compareSaved(n4, i2) >= 0) {
                return this.upperSaved(i2, n6, n4);
            }
            n5 = n6 - i2;
            n6 = i2;
        }
        return this.upperSaved(n2, n6, n4);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);
}

