/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class Version {
    @Deprecated
    public static final Version LUCENE_4_0_0_ALPHA = new Version(4, 0, 0, 0);
    @Deprecated
    public static final Version LUCENE_4_0_0_BETA = new Version(4, 0, 0, 1);
    @Deprecated
    public static final Version LUCENE_4_0_0 = new Version(4, 0, 0, 2);
    @Deprecated
    public static final Version LUCENE_4_1_0 = new Version(4, 1, 0);
    @Deprecated
    public static final Version LUCENE_4_2_0 = new Version(4, 2, 0);
    @Deprecated
    public static final Version LUCENE_4_2_1 = new Version(4, 2, 1);
    @Deprecated
    public static final Version LUCENE_4_3_0 = new Version(4, 3, 0);
    @Deprecated
    public static final Version LUCENE_4_3_1 = new Version(4, 3, 1);
    @Deprecated
    public static final Version LUCENE_4_4_0 = new Version(4, 4, 0);
    @Deprecated
    public static final Version LUCENE_4_5_0 = new Version(4, 5, 0);
    @Deprecated
    public static final Version LUCENE_4_5_1 = new Version(4, 5, 1);
    @Deprecated
    public static final Version LUCENE_4_6_0 = new Version(4, 6, 0);
    @Deprecated
    public static final Version LUCENE_4_6_1 = new Version(4, 6, 1);
    @Deprecated
    public static final Version LUCENE_4_7_0 = new Version(4, 7, 0);
    @Deprecated
    public static final Version LUCENE_4_7_1 = new Version(4, 7, 1);
    @Deprecated
    public static final Version LUCENE_4_7_2 = new Version(4, 7, 2);
    @Deprecated
    public static final Version LUCENE_4_8_0 = new Version(4, 8, 0);
    @Deprecated
    public static final Version LUCENE_4_8_1 = new Version(4, 8, 1);
    @Deprecated
    public static final Version LUCENE_4_9_0 = new Version(4, 9, 0);
    @Deprecated
    public static final Version LUCENE_4_9_1 = new Version(4, 9, 1);
    @Deprecated
    public static final Version LUCENE_4_10_0 = new Version(4, 10, 0);
    @Deprecated
    public static final Version LUCENE_4_10_1 = new Version(4, 10, 1);
    @Deprecated
    public static final Version LUCENE_4_10_2 = new Version(4, 10, 2);
    @Deprecated
    public static final Version LUCENE_4_10_3 = new Version(4, 10, 3);
    @Deprecated
    public static final Version LUCENE_4_10_4 = new Version(4, 10, 4);
    @Deprecated
    public static final Version LUCENE_5_0_0 = new Version(5, 0, 0);
    @Deprecated
    public static final Version LUCENE_5_1_0 = new Version(5, 1, 0);
    @Deprecated
    public static final Version LUCENE_5_2_0 = new Version(5, 2, 0);
    @Deprecated
    public static final Version LUCENE_5_2_1 = new Version(5, 2, 1);
    public static final Version LUCENE_5_3_0;
    public static final Version LATEST;
    @Deprecated
    public static final Version LUCENE_CURRENT;
    @Deprecated
    public static final Version LUCENE_4_0;
    @Deprecated
    public static final Version LUCENE_4_1;
    @Deprecated
    public static final Version LUCENE_4_2;
    @Deprecated
    public static final Version LUCENE_4_3;
    @Deprecated
    public static final Version LUCENE_4_4;
    @Deprecated
    public static final Version LUCENE_4_5;
    @Deprecated
    public static final Version LUCENE_4_6;
    @Deprecated
    public static final Version LUCENE_4_7;
    @Deprecated
    public static final Version LUCENE_4_8;
    @Deprecated
    public static final Version LUCENE_4_9;
    public final int major;
    public final int minor;
    public final int bugfix;
    public final int prerelease;
    private final int encodedValue;

    public static Version fromBits(int n2, int n3, int n4) {
        return new Version(n2, n3, n4);
    }

    private Version(int n2, int n3, int n4) {
        this(n2, n3, n4, 0);
    }

    private Version(int n2, int n3, int n4, int n5) {
        this.major = n2;
        this.minor = n3;
        this.bugfix = n4;
        this.prerelease = n5;
        if (n2 > 255 || n2 < 0) {
            throw new IllegalArgumentException("Illegal major version: " + n2);
        }
        if (n3 > 255 || n3 < 0) {
            throw new IllegalArgumentException("Illegal minor version: " + n3);
        }
        if (n4 > 255 || n4 < 0) {
            throw new IllegalArgumentException("Illegal bugfix version: " + n4);
        }
        if (n5 > 2 || n5 < 0) {
            throw new IllegalArgumentException("Illegal prerelease version: " + n5);
        }
        if (n5 != 0 && (n3 != 0 || n4 != 0)) {
            throw new IllegalArgumentException("Prerelease version only supported with major release (got prerelease: " + n5 + ", minor: " + n3 + ", bugfix: " + n4 + ")");
        }
        this.encodedValue = n2 << 18 | n3 << 10 | n4 << 2 | n5;
        assert (this.encodedIsValid());
    }

    public boolean onOrAfter(Version version) {
        return this.encodedValue >= version.encodedValue;
    }

    public String toString() {
        if (this.prerelease == 0) {
            return "" + this.major + "." + this.minor + "." + this.bugfix;
        }
        return "" + this.major + "." + this.minor + "." + this.bugfix + "." + this.prerelease;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Version && ((Version)object).encodedValue == this.encodedValue;
    }

    private boolean encodedIsValid() {
        assert (this.major == (this.encodedValue >>> 18 & 0xFF));
        assert (this.minor == (this.encodedValue >>> 10 & 0xFF));
        assert (this.bugfix == (this.encodedValue >>> 2 & 0xFF));
        assert (this.prerelease == (this.encodedValue & 3));
        return true;
    }

    public int hashCode() {
        return this.encodedValue;
    }

    static {
        LUCENE_CURRENT = LATEST = (LUCENE_5_3_0 = new Version(5, 3, 0));
        LUCENE_4_0 = LUCENE_4_0_0_ALPHA;
        LUCENE_4_1 = LUCENE_4_1_0;
        LUCENE_4_2 = LUCENE_4_2_0;
        LUCENE_4_3 = LUCENE_4_3_0;
        LUCENE_4_4 = LUCENE_4_4_0;
        LUCENE_4_5 = LUCENE_4_5_0;
        LUCENE_4_6 = LUCENE_4_6_0;
        LUCENE_4_7 = LUCENE_4_7_0;
        LUCENE_4_8 = LUCENE_4_8_0;
        LUCENE_4_9 = LUCENE_4_9_0;
    }
}

