/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Sorter;
import org.apache.lucene.util.a;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.e;

public class Automaton
implements a {
    private int nextState;
    private int nextTransition;
    private int curState = -1;
    private int[] states;
    private final BitSet isAccept;
    private int[] transitions;
    private boolean deterministic = true;
    private final Sorter destMinMaxSorter = new e(){

        private void swapOne(int n2, int n3) {
            int n4 = Automaton.this.transitions[n2];
            ((Automaton)Automaton.this).transitions[n2] = Automaton.this.transitions[n3];
            ((Automaton)Automaton.this).transitions[n3] = n4;
        }

        @Override
        protected void swap(int n2, int n3) {
            int n4 = 3 * n2;
            int n5 = 3 * n3;
            this.swapOne(n4, n5);
            this.swapOne(n4 + 1, n5 + 1);
            this.swapOne(n4 + 2, n5 + 2);
        }

        @Override
        protected int compare(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7 = 3 * n2;
            int n8 = 3 * n3;
            int n9 = Automaton.this.transitions[n7];
            if (n9 < (n6 = Automaton.this.transitions[n8])) {
                return -1;
            }
            if (n9 > n6) {
                return 1;
            }
            int n10 = Automaton.this.transitions[n7 + 1];
            if (n10 < (n5 = Automaton.this.transitions[n8 + 1])) {
                return -1;
            }
            if (n10 > n5) {
                return 1;
            }
            int n11 = Automaton.this.transitions[n7 + 2];
            if (n11 < (n4 = Automaton.this.transitions[n8 + 2])) {
                return -1;
            }
            if (n11 > n4) {
                return 1;
            }
            return 0;
        }
    };
    private final Sorter minMaxDestSorter = new e(){

        private void swapOne(int n2, int n3) {
            int n4 = Automaton.this.transitions[n2];
            ((Automaton)Automaton.this).transitions[n2] = Automaton.this.transitions[n3];
            ((Automaton)Automaton.this).transitions[n3] = n4;
        }

        @Override
        protected void swap(int n2, int n3) {
            int n4 = 3 * n2;
            int n5 = 3 * n3;
            this.swapOne(n4, n5);
            this.swapOne(n4 + 1, n5 + 1);
            this.swapOne(n4 + 2, n5 + 2);
        }

        @Override
        protected int compare(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7 = 3 * n2;
            int n8 = 3 * n3;
            int n9 = Automaton.this.transitions[n7 + 1];
            if (n9 < (n6 = Automaton.this.transitions[n8 + 1])) {
                return -1;
            }
            if (n9 > n6) {
                return 1;
            }
            int n10 = Automaton.this.transitions[n7 + 2];
            if (n10 < (n5 = Automaton.this.transitions[n8 + 2])) {
                return -1;
            }
            if (n10 > n5) {
                return 1;
            }
            int n11 = Automaton.this.transitions[n7];
            if (n11 < (n4 = Automaton.this.transitions[n8])) {
                return -1;
            }
            if (n11 > n4) {
                return 1;
            }
            return 0;
        }
    };

    public Automaton() {
        this(2, 2);
    }

    public Automaton(int n2, int n3) {
        this.states = new int[n2 * 2];
        this.isAccept = new BitSet(n2);
        this.transitions = new int[n3 * 3];
    }

    public int createState() {
        this.growStates();
        int n2 = this.nextState / 2;
        this.states[this.nextState] = -1;
        this.nextState += 2;
        return n2;
    }

    public void setAccept(int n2, boolean bl) {
        if (n2 >= this.getNumStates()) {
            throw new IllegalArgumentException("state=" + n2 + " is out of bounds (numStates=" + this.getNumStates() + ")");
        }
        if (bl) {
            this.isAccept.set(n2);
        } else {
            this.isAccept.clear(n2);
        }
    }

    BitSet getAcceptStates() {
        return this.isAccept;
    }

    public boolean isAccept(int n2) {
        return this.isAccept.get(n2);
    }

    public void addTransition(int n2, int n3, int n4) {
        this.addTransition(n2, n3, n4, n4);
    }

    public void addTransition(int n2, int n3, int n4, int n5) {
        assert (this.nextTransition % 3 == 0);
        if (n2 >= this.nextState / 2) {
            throw new IllegalArgumentException("source=" + n2 + " is out of bounds (maxState is " + (this.nextState / 2 - 1) + ")");
        }
        if (n3 >= this.nextState / 2) {
            throw new IllegalArgumentException("dest=" + n3 + " is out of bounds (max state is " + (this.nextState / 2 - 1) + ")");
        }
        this.growTransitions();
        if (this.curState != n2) {
            if (this.curState != -1) {
                this.finishCurrentState();
            }
            this.curState = n2;
            if (this.states[2 * this.curState] != -1) {
                throw new IllegalStateException("from state (" + n2 + ") already had transitions added");
            }
            assert (this.states[2 * this.curState + 1] == 0);
            this.states[2 * this.curState] = this.nextTransition;
        }
        this.transitions[this.nextTransition++] = n3;
        this.transitions[this.nextTransition++] = n4;
        this.transitions[this.nextTransition++] = n5;
        int n6 = 2 * this.curState + 1;
        this.states[n6] = this.states[n6] + 1;
    }

    public void addEpsilon(int n2, int n3) {
        Transition transition = new Transition();
        int n4 = this.initTransition(n3, transition);
        for (int i2 = 0; i2 < n4; ++i2) {
            this.getNextTransition(transition);
            this.addTransition(n2, transition.dest, transition.min, transition.max);
        }
        if (this.isAccept(n3)) {
            this.setAccept(n2, true);
        }
    }

    private void finishCurrentState() {
        int n2;
        int n3;
        int n4 = this.states[2 * this.curState + 1];
        assert (n4 > 0);
        int n5 = this.states[2 * this.curState];
        int n6 = n5 / 3;
        this.destMinMaxSorter.sort(n6, n6 + n4);
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.transitions[n5 + 3 * n3];
            int n11 = this.transitions[n5 + 3 * n3 + 1];
            int n12 = this.transitions[n5 + 3 * n3 + 2];
            if (n10 == n2) {
                if (n11 <= n9 + 1) {
                    if (n12 <= n9) continue;
                    n9 = n12;
                    continue;
                }
                if (n10 != -1) {
                    this.transitions[n5 + 3 * n7] = n10;
                    this.transitions[n5 + 3 * n7 + 1] = n8;
                    this.transitions[n5 + 3 * n7 + 2] = n9;
                    ++n7;
                }
                n8 = n11;
                n9 = n12;
                continue;
            }
            if (n10 != -1) {
                this.transitions[n5 + 3 * n7] = n10;
                this.transitions[n5 + 3 * n7 + 1] = n8;
                this.transitions[n5 + 3 * n7 + 2] = n9;
                ++n7;
            }
            n10 = n2;
            n8 = n11;
            n9 = n12;
        }
        if (n10 != -1) {
            this.transitions[n5 + 3 * n7] = n10;
            this.transitions[n5 + 3 * n7 + 1] = n8;
            this.transitions[n5 + 3 * n7 + 2] = n9;
            ++n7;
        }
        this.nextTransition -= (n4 - n7) * 3;
        this.states[2 * this.curState + 1] = n7;
        this.minMaxDestSorter.sort(n6, n6 + n7);
        if (this.deterministic && n7 > 1) {
            n3 = this.transitions[n5 + 2];
            for (n2 = 1; n2 < n7; ++n2) {
                n8 = this.transitions[n5 + 3 * n2 + 1];
                if (n8 <= n3) {
                    this.deterministic = false;
                    break;
                }
                n3 = this.transitions[n5 + 3 * n2 + 2];
            }
        }
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void finishState() {
        if (this.curState != -1) {
            this.finishCurrentState();
            this.curState = -1;
        }
    }

    public int getNumStates() {
        return this.nextState / 2;
    }

    public int getNumTransitions() {
        return this.nextTransition / 3;
    }

    public int getNumTransitions(int n2) {
        assert (n2 >= 0);
        int n3 = this.states[2 * n2 + 1];
        if (n3 == -1) {
            return 0;
        }
        return n3;
    }

    private void growStates() {
        if (this.nextState + 2 >= this.states.length) {
            this.states = ArrayUtil.grow(this.states, this.nextState + 2);
        }
    }

    private void growTransitions() {
        if (this.nextTransition + 3 >= this.transitions.length) {
            this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 3);
        }
    }

    public int initTransition(int n2, Transition transition) {
        assert (n2 < this.nextState / 2) : "state=" + n2 + " nextState=" + this.nextState;
        transition.source = n2;
        transition.transitionUpto = this.states[2 * n2];
        return this.getNumTransitions(n2);
    }

    public void getNextTransition(Transition transition) {
        assert (transition.transitionUpto + 3 - this.states[2 * transition.source] <= 3 * this.states[2 * transition.source + 1]);
        assert (this.transitionSorted(transition));
        transition.dest = this.transitions[transition.transitionUpto++];
        transition.min = this.transitions[transition.transitionUpto++];
        transition.max = this.transitions[transition.transitionUpto++];
    }

    private boolean transitionSorted(Transition transition) {
        int n2 = transition.transitionUpto;
        if (n2 == this.states[2 * transition.source]) {
            return true;
        }
        int n3 = this.transitions[n2];
        int n4 = this.transitions[n2 + 1];
        int n5 = this.transitions[n2 + 2];
        if (n4 > transition.min) {
            return true;
        }
        if (n4 < transition.min) {
            return false;
        }
        if (n5 > transition.max) {
            return true;
        }
        if (n5 < transition.max) {
            return false;
        }
        if (n3 > transition.dest) {
            return true;
        }
        if (n3 < transition.dest) {
            return false;
        }
        return false;
    }

    public void getTransition(int n2, int n3, Transition transition) {
        int n4 = this.states[2 * n2] + 3 * n3;
        transition.source = n2;
        transition.dest = this.transitions[n4++];
        transition.min = this.transitions[n4++];
        transition.max = this.transitions[n4++];
    }

    static void appendCharString(int n2, StringBuilder stringBuilder) {
        if (n2 >= 33 && n2 <= 126 && n2 != 92 && n2 != 34) {
            stringBuilder.appendCodePoint(n2);
        } else {
            stringBuilder.append("\\\\U");
            String string = Integer.toHexString(n2);
            if (n2 < 16) {
                stringBuilder.append("0000000").append(string);
            } else if (n2 < 256) {
                stringBuilder.append("000000").append(string);
            } else if (n2 < 4096) {
                stringBuilder.append("00000").append(string);
            } else if (n2 < 65536) {
                stringBuilder.append("0000").append(string);
            } else if (n2 < 0x100000) {
                stringBuilder.append("000").append(string);
            } else if (n2 < 0x1000000) {
                stringBuilder.append("00").append(string);
            } else if (n2 < 0x10000000) {
                stringBuilder.append("0").append(string);
            } else {
                stringBuilder.append(string);
            }
        }
    }

    int[] getStartPoints() {
        int n2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        for (int i2 = 0; i2 < this.nextState; i2 += 2) {
            int n3 = n2 + 3 * this.states[i2 + 1];
            for (n2 = this.states[i2]; n2 < n3; n2 += 3) {
                int n4 = this.transitions[n2 + 1];
                int n5 = this.transitions[n2 + 2];
                hashSet.add(n4);
                if (n5 >= 0x10FFFF) continue;
                hashSet.add(n5 + 1);
            }
        }
        int[] nArray = new int[hashSet.size()];
        n2 = 0;
        for (Integer n6 : hashSet) {
            nArray[n2++] = n6;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public int step(int n2, int n3) {
        int n4;
        assert (n2 >= 0);
        assert (n3 >= 0);
        int n5 = n4 + 3 * this.states[2 * n2 + 1];
        for (n4 = this.states[2 * n2]; n4 < n5; n4 += 3) {
            int n6 = this.transitions[n4];
            int n7 = this.transitions[n4 + 1];
            int n8 = this.transitions[n4 + 2];
            if (n7 > n3 || n3 > n8) continue;
            return n6;
        }
        return -1;
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf(this.states) + RamUsageEstimator.sizeOf(this.transitions) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)(this.isAccept.size() / 8) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 12L + 1L;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public static class Builder {
        private int nextState = 0;
        private final BitSet isAccept;
        private int[] transitions;
        private int nextTransition = 0;
        private final Sorter sorter = new e(){

            private void swapOne(int n2, int n3) {
                int n4 = transitions[n2];
                ((Builder)this).transitions[n2] = transitions[n3];
                ((Builder)this).transitions[n3] = n4;
            }

            @Override
            protected void swap(int n2, int n3) {
                int n4 = 4 * n2;
                int n5 = 4 * n3;
                this.swapOne(n4, n5);
                this.swapOne(n4 + 1, n5 + 1);
                this.swapOne(n4 + 2, n5 + 2);
                this.swapOne(n4 + 3, n5 + 3);
            }

            @Override
            protected int compare(int n2, int n3) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = 4 * n2;
                int n9 = 4 * n3;
                int n10 = transitions[n8];
                if (n10 < (n7 = transitions[n9])) {
                    return -1;
                }
                if (n10 > n7) {
                    return 1;
                }
                int n11 = transitions[n8 + 2];
                if (n11 < (n6 = transitions[n9 + 2])) {
                    return -1;
                }
                if (n11 > n6) {
                    return 1;
                }
                int n12 = transitions[n8 + 3];
                if (n12 < (n5 = transitions[n9 + 3])) {
                    return -1;
                }
                if (n12 > n5) {
                    return 1;
                }
                int n13 = transitions[n8 + 1];
                if (n13 < (n4 = transitions[n9 + 1])) {
                    return -1;
                }
                if (n13 > n4) {
                    return 1;
                }
                return 0;
            }
        };

        public Builder() {
            this(16, 16);
        }

        public Builder(int n2, int n3) {
            this.isAccept = new BitSet(n2);
            this.transitions = new int[n3 * 4];
        }

        public void addTransition(int n2, int n3, int n4) {
            this.addTransition(n2, n3, n4, n4);
        }

        public void addTransition(int n2, int n3, int n4, int n5) {
            if (this.transitions.length < this.nextTransition + 4) {
                this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 4);
            }
            this.transitions[this.nextTransition++] = n2;
            this.transitions[this.nextTransition++] = n3;
            this.transitions[this.nextTransition++] = n4;
            this.transitions[this.nextTransition++] = n5;
        }

        public Automaton finish() {
            int n2;
            int n3 = this.nextState;
            int n4 = this.nextTransition / 4;
            Automaton automaton = new Automaton(n3, n4);
            for (n2 = 0; n2 < n3; ++n2) {
                automaton.createState();
                automaton.setAccept(n2, this.isAccept(n2));
            }
            this.sorter.sort(0, n4);
            for (n2 = 0; n2 < this.nextTransition; n2 += 4) {
                automaton.addTransition(this.transitions[n2], this.transitions[n2 + 1], this.transitions[n2 + 2], this.transitions[n2 + 3]);
            }
            automaton.finishState();
            return automaton;
        }

        public int createState() {
            return this.nextState++;
        }

        public void setAccept(int n2, boolean bl) {
            if (n2 >= this.getNumStates()) {
                throw new IllegalArgumentException("state=" + n2 + " is out of bounds (numStates=" + this.getNumStates() + ")");
            }
            this.isAccept.set(n2, bl);
        }

        public boolean isAccept(int n2) {
            return this.isAccept.get(n2);
        }

        public int getNumStates() {
            return this.nextState;
        }
    }
}

