/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.UTF32ToUTF8;
import org.apache.lucene.util.automaton.a;

public class CompiledAutomaton {
    public final AUTOMATON_TYPE type;
    public final BytesRef term;
    public final a runAutomaton;
    public final Automaton automaton;
    public final BytesRef commonSuffixRef;
    public final Boolean finite;
    public final int sinkState;
    private Transition transition = new Transition();

    private static int findSinkState(Automaton automaton) {
        int n2 = automaton.getNumStates();
        Transition transition = new Transition();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!automaton.isAccept(i2)) continue;
            int n4 = automaton.initTransition(i2, transition);
            boolean bl = false;
            for (int i3 = 0; i3 < n4; ++i3) {
                automaton.getNextTransition(transition);
                if (transition.dest != i2 || transition.min != 0 || transition.max != 255) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public CompiledAutomaton(Automaton automaton, Boolean bl, boolean bl2) {
        this(automaton, bl, bl2, 10000, false);
    }

    public CompiledAutomaton(Automaton automaton, Boolean bl, boolean bl2, int n2, boolean bl3) {
        Comparable<IntsRef> comparable;
        if (automaton.getNumStates() == 0) {
            automaton = new Automaton();
            automaton.createState();
        }
        if (bl2) {
            if (Operations.isEmpty(automaton)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            boolean bl4 = bl3 ? Operations.isTotal(automaton, 0, 255) : Operations.isTotal(automaton);
            if (bl4) {
                this.type = AUTOMATON_TYPE.ALL;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            comparable = Operations.getSingleton(automaton = Operations.determinize(automaton, n2));
            if (comparable != null) {
                this.type = AUTOMATON_TYPE.SINGLE;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.term = bl3 ? StringHelper.intsRefToBytesRef(comparable) : new BytesRef(UnicodeUtil.newString(comparable.ints, comparable.offset, comparable.length));
                this.sinkState = -1;
                return;
            }
        }
        this.type = AUTOMATON_TYPE.NORMAL;
        this.term = null;
        this.finite = bl == null ? Boolean.valueOf(Operations.isFinite(automaton)) : bl;
        Automaton automaton2 = bl3 ? automaton : new UTF32ToUTF8().convert(automaton);
        if (this.finite.booleanValue()) {
            this.commonSuffixRef = null;
        } else {
            comparable = Operations.getCommonSuffixBytesRef(automaton2, n2);
            this.commonSuffixRef = ((BytesRef)comparable).length == 0 ? null : comparable;
        }
        this.runAutomaton = new a(automaton2, true, n2);
        this.automaton = this.runAutomaton.automaton;
        this.sinkState = CompiledAutomaton.findSinkState(this.automaton);
    }

    private BytesRef addTail(int n2, BytesRefBuilder bytesRefBuilder, int n3, int n4) {
        int n5 = -1;
        int n6 = this.automaton.initTransition(n2, this.transition);
        int n7 = 0;
        while (n7 < n6) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.min >= n4) break;
            n5 = n7++;
        }
        assert (n5 != -1);
        this.automaton.getTransition(n2, n5, this.transition);
        n7 = this.transition.max > n4 - 1 ? n4 - 1 : this.transition.max;
        bytesRefBuilder.grow(1 + n3);
        bytesRefBuilder.setByteAt(n3, (byte)n7);
        n2 = this.transition.dest;
        ++n3;
        while (true) {
            if ((n6 = this.automaton.getNumTransitions(n2)) == 0) {
                assert (this.runAutomaton.isAccept(n2));
                bytesRefBuilder.setLength(n3);
                return bytesRefBuilder.get();
            }
            this.automaton.getTransition(n2, n6 - 1, this.transition);
            bytesRefBuilder.grow(1 + n3);
            bytesRefBuilder.setByteAt(n3, (byte)this.transition.max);
            n2 = this.transition.dest;
            ++n3;
        }
    }

    public TermsEnum getTermsEnum(Terms terms) throws IOException {
        switch (this.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return terms.iterator();
            }
            case SINGLE: {
                return new SingleTermsEnum(terms.iterator(), this.term);
            }
            case NORMAL: {
                return terms.intersect(this, null);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    public BytesRef floor(BytesRef bytesRef, BytesRefBuilder bytesRefBuilder) {
        int n2 = this.runAutomaton.getInitialState();
        if (bytesRef.length == 0) {
            if (this.runAutomaton.isAccept(n2)) {
                bytesRefBuilder.clear();
                return bytesRefBuilder.get();
            }
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        while (true) {
            int n4 = bytesRef.bytes[bytesRef.offset + n3] & 0xFF;
            int n5 = this.runAutomaton.step(n2, n4);
            if (n3 == bytesRef.length - 1) {
                if (n5 != -1 && this.runAutomaton.isAccept(n5)) {
                    bytesRefBuilder.grow(1 + n3);
                    bytesRefBuilder.setByteAt(n3, (byte)n4);
                    bytesRefBuilder.setLength(bytesRef.length);
                    return bytesRefBuilder.get();
                }
                n5 = -1;
            }
            if (n5 == -1) {
                while (true) {
                    int n6;
                    if ((n6 = this.automaton.getNumTransitions(n2)) == 0) {
                        assert (this.runAutomaton.isAccept(n2));
                        bytesRefBuilder.setLength(n3);
                        return bytesRefBuilder.get();
                    }
                    this.automaton.getTransition(n2, 0, this.transition);
                    if (n4 - 1 >= this.transition.min) break;
                    if (this.runAutomaton.isAccept(n2)) {
                        bytesRefBuilder.setLength(n3);
                        return bytesRefBuilder.get();
                    }
                    if (arrayList.size() == 0) {
                        return null;
                    }
                    n2 = (Integer)arrayList.remove(arrayList.size() - 1);
                    n4 = bytesRef.bytes[bytesRef.offset + --n3] & 0xFF;
                }
                return this.addTail(n2, bytesRefBuilder, n3, n4);
            }
            bytesRefBuilder.grow(1 + n3);
            bytesRefBuilder.setByteAt(n3, (byte)n4);
            arrayList.add(n2);
            n2 = n5;
            ++n3;
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.runAutomaton == null ? 0 : this.runAutomaton.hashCode());
        n3 = 31 * n3 + (this.term == null ? 0 : this.term.hashCode());
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompiledAutomaton compiledAutomaton = (CompiledAutomaton)object;
        if (this.type != compiledAutomaton.type) {
            return false;
        }
        return !(this.type == AUTOMATON_TYPE.SINGLE ? !this.term.equals(compiledAutomaton.term) : this.type == AUTOMATON_TYPE.NORMAL && !this.runAutomaton.equals(compiledAutomaton.runAutomaton));
    }

    public static enum AUTOMATON_TYPE {
        NONE,
        ALL,
        SINGLE,
        NORMAL;

    }
}

