/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.ArrayUtil;

final class SortedIntSet {
    int[] values;
    int[] counts;
    int upto;
    private int hashCode;
    private final Map<Integer, Integer> map = new TreeMap<Integer, Integer>();
    private boolean useTreeMap;

    public SortedIntSet(int n2) {
        this.values = new int[n2];
        this.counts = new int[n2];
    }

    public void incr(int n2) {
        int n3;
        if (this.useTreeMap) {
            Integer n4 = n2;
            Integer n5 = this.map.get(n4);
            if (n5 == null) {
                this.map.put(n4, 1);
            } else {
                this.map.put(n4, 1 + n5);
            }
            return;
        }
        if (this.upto == this.values.length) {
            this.values = ArrayUtil.grow(this.values, 1 + this.upto);
            this.counts = ArrayUtil.grow(this.counts, 1 + this.upto);
        }
        for (n3 = 0; n3 < this.upto; ++n3) {
            if (this.values[n3] == n2) {
                int n6 = n3;
                this.counts[n6] = this.counts[n6] + 1;
                return;
            }
            if (n2 >= this.values[n3]) continue;
            for (int i2 = this.upto - 1; i2 >= n3; --i2) {
                this.values[1 + i2] = this.values[i2];
                this.counts[1 + i2] = this.counts[i2];
            }
            this.values[n3] = n2;
            this.counts[n3] = 1;
            ++this.upto;
            return;
        }
        this.values[this.upto] = n2;
        this.counts[this.upto] = 1;
        ++this.upto;
        if (this.upto == 30) {
            this.useTreeMap = true;
            for (n3 = 0; n3 < this.upto; ++n3) {
                this.map.put(this.values[n3], this.counts[n3]);
            }
        }
    }

    public void decr(int n2) {
        if (this.useTreeMap) {
            int n3 = this.map.get(n2);
            if (n3 == 1) {
                this.map.remove(n2);
            } else {
                this.map.put(n2, n3 - 1);
            }
            if (this.map.size() == 0) {
                this.useTreeMap = false;
                this.upto = 0;
            }
            return;
        }
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (this.values[i2] != n2) continue;
            int n4 = i2;
            this.counts[n4] = this.counts[n4] - 1;
            if (this.counts[i2] == 0) {
                int n5 = this.upto - 1;
                while (i2 < n5) {
                    this.values[i2] = this.values[i2 + 1];
                    this.counts[i2] = this.counts[i2 + 1];
                    ++i2;
                }
                this.upto = n5;
            }
            return;
        }
        assert (false);
    }

    public void computeHash() {
        if (this.useTreeMap) {
            if (this.map.size() > this.values.length) {
                int n2 = ArrayUtil.oversize(this.map.size(), 4);
                this.values = new int[n2];
                this.counts = new int[n2];
            }
            this.hashCode = this.map.size();
            this.upto = 0;
            for (int n3 : this.map.keySet()) {
                this.hashCode = 683 * this.hashCode + n3;
                this.values[this.upto++] = n3;
            }
        } else {
            this.hashCode = this.upto;
            for (int i2 = 0; i2 < this.upto; ++i2) {
                this.hashCode = 683 * this.hashCode + this.values[i2];
            }
        }
    }

    public FrozenIntSet freeze(int n2) {
        int[] nArray = new int[this.upto];
        System.arraycopy(this.values, 0, nArray, 0, this.upto);
        return new FrozenIntSet(nArray, this.hashCode, n2);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FrozenIntSet)) {
            return false;
        }
        FrozenIntSet frozenIntSet = (FrozenIntSet)object;
        if (this.hashCode != frozenIntSet.hashCode) {
            return false;
        }
        if (frozenIntSet.values.length != this.upto) {
            return false;
        }
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (frozenIntSet.values[i2] == this.values[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.values[i2]).append(':').append(this.counts[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static final class FrozenIntSet {
        final int[] values;
        final int hashCode;
        final int state;

        public FrozenIntSet(int[] nArray, int n2, int n3) {
            this.values = nArray;
            this.hashCode = n2;
            this.state = n3;
        }

        public FrozenIntSet(int n2, int n3) {
            this.values = new int[]{n2};
            this.state = n3;
            this.hashCode = 683 + n2;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof FrozenIntSet) {
                FrozenIntSet frozenIntSet = (FrozenIntSet)object;
                if (this.hashCode != frozenIntSet.hashCode) {
                    return false;
                }
                if (frozenIntSet.values.length != this.values.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (frozenIntSet.values[i2] == this.values[i2]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof SortedIntSet) {
                SortedIntSet sortedIntSet = (SortedIntSet)object;
                if (this.hashCode != sortedIntSet.hashCode) {
                    return false;
                }
                if (sortedIntSet.values.length != this.values.length) {
                    return false;
                }
                for (int i3 = 0; i3 < this.values.length; ++i3) {
                    if (sortedIntSet.values[i3] == this.values[i3]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.values[i2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

