/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.ForwardBytesReader;
import org.apache.lucene.util.fst.ReverseBytesReader;

class BytesStore
extends DataOutput
implements a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesStore.class) + RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private byte[] current;
    private int nextWrite;

    public BytesStore(int n2) {
        this.blockBits = n2;
        this.blockSize = 1 << n2;
        this.blockMask = this.blockSize - 1;
        this.nextWrite = this.blockSize;
    }

    public BytesStore(DataInput dataInput, long l2, int n2) throws IOException {
        int n3;
        int n4 = 2;
        int n5 = 1;
        while ((long)n4 < l2 && n4 < n2) {
            n4 *= 2;
            ++n5;
        }
        this.blockBits = n5;
        this.blockSize = n4;
        this.blockMask = n4 - 1;
        for (long i2 = l2; i2 > 0L; i2 -= (long)n3) {
            n3 = (int)Math.min((long)n4, i2);
            byte[] byArray = new byte[n3];
            dataInput.readBytes(byArray, 0, byArray.length);
            this.blocks.add(byArray);
        }
        this.nextWrite = this.blocks.get(this.blocks.size() - 1).length;
    }

    @Override
    public void writeByte(byte by) {
        if (this.nextWrite == this.blockSize) {
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
        this.current[this.nextWrite++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.blockSize - this.nextWrite;
            if (n3 <= n4) {
                assert (byArray != null);
                assert (this.current != null);
                System.arraycopy(byArray, n2, this.current, this.nextWrite, n3);
                this.nextWrite += n3;
                break;
            }
            if (n4 > 0) {
                System.arraycopy(byArray, n2, this.current, this.nextWrite, n4);
                n2 += n4;
                n3 -= n4;
            }
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
    }

    int getBlockBits() {
        return this.blockBits;
    }

    void writeBytes(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 + (long)n3 <= this.getPosition()) : "dest=" + l2 + " pos=" + this.getPosition() + " len=" + n3;
        long l3 = l2 + (long)n3;
        int n4 = (int)(l3 >> this.blockBits);
        int n5 = (int)(l3 & (long)this.blockMask);
        if (n5 == 0) {
            --n4;
            n5 = this.blockSize;
        }
        byte[] byArray2 = this.blocks.get(n4);
        while (n3 > 0) {
            if (n3 <= n5) {
                System.arraycopy(byArray, n2, byArray2, n5 - n3, n3);
                break;
            }
            System.arraycopy(byArray, n2 + (n3 -= n5), byArray2, 0, n5);
            byArray2 = this.blocks.get(--n4);
            n5 = this.blockSize;
        }
    }

    public void copyBytes(long l2, long l3, int n2) {
        assert (l2 < l3);
        long l4 = l2 + (long)n2;
        int n3 = (int)(l4 >> this.blockBits);
        int n4 = (int)(l4 & (long)this.blockMask);
        if (n4 == 0) {
            --n3;
            n4 = this.blockSize;
        }
        byte[] byArray = this.blocks.get(n3);
        while (n2 > 0) {
            if (n2 <= n4) {
                this.writeBytes(l3, byArray, n4 - n2, n2);
                break;
            }
            this.writeBytes(l3 + (long)(n2 -= n4), byArray, 0, n4);
            byArray = this.blocks.get(--n3);
            n4 = this.blockSize;
        }
    }

    public void reverse(long l2, long l3) {
        assert (l2 < l3);
        assert (l3 < this.getPosition());
        int n2 = (int)(l2 >> this.blockBits);
        int n3 = (int)(l2 & (long)this.blockMask);
        byte[] byArray = this.blocks.get(n2);
        int n4 = (int)(l3 >> this.blockBits);
        int n5 = (int)(l3 & (long)this.blockMask);
        byte[] byArray2 = this.blocks.get(n4);
        int n6 = (int)(l3 - l2 + 1L) / 2;
        for (int i2 = 0; i2 < n6; ++i2) {
            byte by = byArray[n3];
            byArray[n3] = byArray2[n5];
            byArray2[n5] = by;
            if (++n3 == this.blockSize) {
                byArray = this.blocks.get(++n2);
                n3 = 0;
            }
            if (--n5 != -1) continue;
            byArray2 = this.blocks.get(--n4);
            n5 = this.blockSize - 1;
        }
    }

    public void skipBytes(int n2) {
        while (n2 > 0) {
            int n3 = this.blockSize - this.nextWrite;
            if (n2 <= n3) {
                this.nextWrite += n2;
                break;
            }
            n2 -= n3;
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
    }

    public long getPosition() {
        return ((long)this.blocks.size() - 1L) * (long)this.blockSize + (long)this.nextWrite;
    }

    public void truncate(long l2) {
        assert (l2 <= this.getPosition());
        assert (l2 >= 0L);
        int n2 = (int)(l2 >> this.blockBits);
        this.nextWrite = (int)(l2 & (long)this.blockMask);
        if (this.nextWrite == 0) {
            --n2;
            this.nextWrite = this.blockSize;
        }
        this.blocks.subList(n2 + 1, this.blocks.size()).clear();
        this.current = (byte[])(l2 == 0L ? null : this.blocks.get(n2));
        assert (l2 == this.getPosition());
    }

    public void finish() {
        if (this.current != null) {
            byte[] byArray = new byte[this.nextWrite];
            System.arraycopy(this.current, 0, byArray, 0, this.nextWrite);
            this.blocks.set(this.blocks.size() - 1, byArray);
            this.current = null;
        }
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        for (byte[] byArray : this.blocks) {
            dataOutput.writeBytes(byArray, 0, byArray.length);
        }
    }

    public FST.a getForwardReader() {
        if (this.blocks.size() == 1) {
            return new ForwardBytesReader(this.blocks.get(0));
        }
        return new FST.a(){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            {
                this.nextRead = BytesStore.this.blockSize;
            }

            @Override
            public byte readByte() {
                if (this.nextRead == BytesStore.this.blockSize) {
                    this.current = (byte[])BytesStore.this.blocks.get(this.nextBuffer++);
                    this.nextRead = 0;
                }
                return this.current[this.nextRead++];
            }

            @Override
            public void skipBytes(long l2) {
                this.setPosition(this.getPosition() + l2);
            }

            @Override
            public void readBytes(byte[] byArray, int n2, int n3) {
                while (n3 > 0) {
                    int n4 = BytesStore.this.blockSize - this.nextRead;
                    if (n3 <= n4) {
                        System.arraycopy(this.current, this.nextRead, byArray, n2, n3);
                        this.nextRead += n3;
                        break;
                    }
                    if (n4 > 0) {
                        System.arraycopy(this.current, this.nextRead, byArray, n2, n4);
                        n2 += n4;
                        n3 -= n4;
                    }
                    this.current = (byte[])BytesStore.this.blocks.get(this.nextBuffer++);
                    this.nextRead = 0;
                }
            }

            @Override
            public long getPosition() {
                return ((long)this.nextBuffer - 1L) * (long)BytesStore.this.blockSize + (long)this.nextRead;
            }

            @Override
            public void setPosition(long l2) {
                int n2 = (int)(l2 >> BytesStore.this.blockBits);
                this.nextBuffer = n2 + 1;
                this.current = (byte[])BytesStore.this.blocks.get(n2);
                this.nextRead = (int)(l2 & (long)BytesStore.this.blockMask);
                assert (this.getPosition() == l2);
            }
        };
    }

    public FST.a getReverseReader() {
        return this.getReverseReader(true);
    }

    FST.a getReverseReader(boolean bl) {
        if (bl && this.blocks.size() == 1) {
            return new ReverseBytesReader(this.blocks.get(0));
        }
        return new FST.a(){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            {
                this.current = BytesStore.this.blocks.size() == 0 ? null : (byte[])BytesStore.this.blocks.get(0);
                this.nextBuffer = -1;
                this.nextRead = 0;
            }

            @Override
            public byte readByte() {
                if (this.nextRead == -1) {
                    this.current = (byte[])BytesStore.this.blocks.get(this.nextBuffer--);
                    this.nextRead = BytesStore.this.blockSize - 1;
                }
                return this.current[this.nextRead--];
            }

            @Override
            public void skipBytes(long l2) {
                this.setPosition(this.getPosition() - l2);
            }

            @Override
            public void readBytes(byte[] byArray, int n2, int n3) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    byArray[n2 + i2] = this.readByte();
                }
            }

            @Override
            public long getPosition() {
                return ((long)this.nextBuffer + 1L) * (long)BytesStore.this.blockSize + (long)this.nextRead;
            }

            @Override
            public void setPosition(long l2) {
                int n2 = (int)(l2 >> BytesStore.this.blockBits);
                this.nextBuffer = n2 - 1;
                this.current = (byte[])BytesStore.this.blocks.get(n2);
                this.nextRead = (int)(l2 & (long)BytesStore.this.blockMask);
                assert (this.getPosition() == l2) : "pos=" + l2 + " getPos()=" + this.getPosition();
            }
        };
    }

    @Override
    public long ramBytesUsed() {
        long l2 = BASE_RAM_BYTES_USED;
        for (byte[] byArray : this.blocks) {
            l2 += RamUsageEstimator.sizeOf(byArray);
        }
        return l2;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(numBlocks=" + this.blocks.size() + ")";
    }
}

