/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

abstract class FSTEnum<T> {
    protected final FST<T> fst;
    protected FST.Arc<T>[] arcs = new FST.Arc[10];
    protected T[] output = new Object[10];
    protected final T NO_OUTPUT;
    protected final FST.a fstReader;
    protected final FST.Arc<T> scratchArc = new FST.Arc();
    protected int upto;

    protected FSTEnum(FST<T> fST) {
        this.fst = fST;
        this.fstReader = fST.getBytesReader();
        this.NO_OUTPUT = fST.outputs.getNoOutput();
        fST.getFirstArc(this.getArc(0));
        this.output[0] = this.NO_OUTPUT;
    }

    protected abstract void setCurrentLabel(int var1);

    protected abstract void grow();

    protected void doNext() throws IOException {
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
        } else {
            while (this.arcs[this.upto].isLast()) {
                --this.upto;
                if (this.upto != 0) continue;
                return;
            }
            this.fst.readNextArc(this.arcs[this.upto], this.fstReader);
        }
        this.pushFirst();
    }

    private void incr() {
        Object[] objectArray;
        ++this.upto;
        this.grow();
        if (this.arcs.length <= this.upto) {
            objectArray = new FST.Arc[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, objectArray, 0, this.arcs.length);
            this.arcs = objectArray;
        }
        if (this.output.length <= this.upto) {
            objectArray = new Object[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.output, 0, objectArray, 0, this.output.length);
            this.output = objectArray;
        }
    }

    private void pushFirst() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
            if (arc.label == -1) break;
            this.setCurrentLabel(arc.label);
            this.incr();
            FST.Arc<T> arc2 = this.getArc(this.upto);
            this.fst.readFirstTargetArc(arc, arc2, this.fstReader);
            arc = arc2;
        }
    }

    private FST.Arc<T> getArc(int n2) {
        if (this.arcs[n2] == null) {
            this.arcs[n2] = new FST.Arc();
        }
        return this.arcs[n2];
    }
}

