/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;

final class NodeHash<T> {
    private PagedGrowableWriter table;
    private long count;
    private long mask = 15L;
    private final FST<T> fst;
    private final FST.Arc<T> scratchArc = new FST.Arc();
    private final FST.a in;

    public NodeHash(FST<T> fST, FST.a a2) {
        this.table = new PagedGrowableWriter(16L, 0x8000000, 8, 0.0f);
        this.fst = fST;
        this.in = a2;
    }

    private boolean nodesEqual(Builder.UnCompiledNode<T> unCompiledNode, long l2) throws IOException {
        this.fst.readFirstRealTargetArc(l2, this.scratchArc, this.in);
        if (this.scratchArc.bytesPerArc != 0 && unCompiledNode.numArcs != this.scratchArc.numArcs) {
            return false;
        }
        for (int i2 = 0; i2 < unCompiledNode.numArcs; ++i2) {
            Builder.Arc arc = unCompiledNode.arcs[i2];
            if (arc.label != this.scratchArc.label || !arc.output.equals(this.scratchArc.output) || ((Builder.CompiledNode)arc.target).node != this.scratchArc.target || !arc.nextFinalOutput.equals(this.scratchArc.nextFinalOutput) || arc.isFinal != this.scratchArc.isFinal()) {
                return false;
            }
            if (this.scratchArc.isLast()) {
                return i2 == unCompiledNode.numArcs - 1;
            }
            this.fst.readNextRealArc(this.scratchArc, this.in);
        }
        return false;
    }

    private long hash(Builder.UnCompiledNode<T> unCompiledNode) {
        int n2 = 31;
        long l2 = 0L;
        for (int i2 = 0; i2 < unCompiledNode.numArcs; ++i2) {
            Builder.Arc arc = unCompiledNode.arcs[i2];
            l2 = 31L * l2 + (long)arc.label;
            long l3 = ((Builder.CompiledNode)arc.target).node;
            l2 = 31L * l2 + (long)((int)(l3 ^ l3 >> 32));
            l2 = 31L * l2 + (long)arc.output.hashCode();
            l2 = 31L * l2 + (long)arc.nextFinalOutput.hashCode();
            if (!arc.isFinal) continue;
            l2 += 17L;
        }
        return l2 & Long.MAX_VALUE;
    }

    private long hash(long l2) throws IOException {
        int n2 = 31;
        long l3 = 0L;
        this.fst.readFirstRealTargetArc(l2, this.scratchArc, this.in);
        while (true) {
            l3 = 31L * l3 + (long)this.scratchArc.label;
            l3 = 31L * l3 + (long)((int)(this.scratchArc.target ^ this.scratchArc.target >> 32));
            l3 = 31L * l3 + (long)this.scratchArc.output.hashCode();
            l3 = 31L * l3 + (long)this.scratchArc.nextFinalOutput.hashCode();
            if (this.scratchArc.isFinal()) {
                l3 += 17L;
            }
            if (this.scratchArc.isLast()) break;
            this.fst.readNextRealArc(this.scratchArc, this.in);
        }
        return l3 & Long.MAX_VALUE;
    }

    public long add(Builder<T> builder, Builder.UnCompiledNode<T> unCompiledNode) throws IOException {
        long l2 = this.hash(unCompiledNode);
        long l3 = l2 & this.mask;
        int n2 = 0;
        while (true) {
            long l4;
            if ((l4 = this.table.get(l3)) == 0L) {
                long l5 = this.fst.addNode(builder, unCompiledNode);
                assert (this.hash(l5) == l2) : "frozenHash=" + this.hash(l5) + " vs h=" + l2;
                ++this.count;
                this.table.set(l3, l5);
                if (this.count > 2L * this.table.size() / 3L) {
                    this.rehash();
                }
                return l5;
            }
            if (this.nodesEqual(unCompiledNode, l4)) {
                return l4;
            }
            l3 = l3 + (long)(++n2) & this.mask;
        }
    }

    private void addNew(long l2) throws IOException {
        long l3 = this.hash(l2) & this.mask;
        int n2 = 0;
        while (true) {
            if (this.table.get(l3) == 0L) break;
            l3 = l3 + (long)(++n2) & this.mask;
        }
        this.table.set(l3, l2);
    }

    private void rehash() throws IOException {
        PagedGrowableWriter pagedGrowableWriter = this.table;
        this.table = new PagedGrowableWriter(2L * pagedGrowableWriter.size(), 0x40000000, PackedInts.bitsRequired(this.count), 0.0f);
        this.mask = this.table.size() - 1L;
        for (long i2 = 0L; i2 < pagedGrowableWriter.size(); ++i2) {
            long l2 = pagedGrowableWriter.get(i2);
            if (l2 == 0L) continue;
            this.addNew(l2);
        }
    }
}

