/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.mutable;

import org.apache.lucene.util.mutable.MutableValue;

public class MutableValueFloat
extends MutableValue {
    public float value;

    @Override
    public Object toObject() {
        assert (this.exists || 0.0f == this.value);
        return this.exists ? Float.valueOf(this.value) : null;
    }

    @Override
    public void copy(MutableValue mutableValue) {
        MutableValueFloat mutableValueFloat = (MutableValueFloat)mutableValue;
        this.value = mutableValueFloat.value;
        this.exists = mutableValueFloat.exists;
    }

    @Override
    public MutableValue duplicate() {
        MutableValueFloat mutableValueFloat = new MutableValueFloat();
        mutableValueFloat.value = this.value;
        mutableValueFloat.exists = this.exists;
        return mutableValueFloat;
    }

    @Override
    public boolean equalsSameType(Object object) {
        assert (this.exists || 0.0f == this.value);
        MutableValueFloat mutableValueFloat = (MutableValueFloat)object;
        return this.value == mutableValueFloat.value && this.exists == mutableValueFloat.exists;
    }

    @Override
    public int compareSameType(Object object) {
        assert (this.exists || 0.0f == this.value);
        MutableValueFloat mutableValueFloat = (MutableValueFloat)object;
        int n2 = Float.compare(this.value, mutableValueFloat.value);
        if (n2 != 0) {
            return n2;
        }
        if (this.exists == mutableValueFloat.exists) {
            return 0;
        }
        return this.exists ? 1 : -1;
    }

    public int hashCode() {
        assert (this.exists || 0.0f == this.value);
        return Float.floatToIntBits(this.value);
    }
}

