/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.packed.AbstractBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedWriter
extends AbstractBlockPackedWriter {
    public BlockPackedWriter(DataOutput dataOutput, int n2) {
        super(dataOutput, n2);
    }

    @Override
    protected void flush() throws IOException {
        int n2;
        assert (this.off > 0);
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        for (int i2 = 0; i2 < this.off; ++i2) {
            l2 = Math.min(this.values[i2], l2);
            l3 = Math.max(this.values[i2], l3);
        }
        long l4 = l3 - l2;
        int n3 = n2 = l4 == 0L ? 0 : PackedInts.unsignedBitsRequired(l4);
        if (n2 == 64) {
            l2 = 0L;
        } else if (l2 > 0L) {
            l2 = Math.max(0L, l3 - PackedInts.maxValue(n2));
        }
        int n4 = n2 << 1 | (l2 == 0L ? 1 : 0);
        this.out.writeByte((byte)n4);
        if (l2 != 0L) {
            BlockPackedWriter.writeVLong(this.out, BitUtil.zigZagEncode(l2) - 1L);
        }
        if (n2 > 0) {
            if (l2 != 0L) {
                int n5 = 0;
                while (n5 < this.off) {
                    int n6 = n5++;
                    this.values[n6] = this.values[n6] - l2;
                }
            }
            this.writeValues(n2);
        }
        this.off = 0;
    }
}

