/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

class DeltaPackedLongValues
extends PackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DeltaPackedLongValues.class);
    final long[] mins;

    DeltaPackedLongValues(int n2, int n3, PackedInts.Reader[] readerArray, long[] lArray, long l2, long l3) {
        super(n2, n3, readerArray, l2, l3);
        assert (readerArray.length == lArray.length);
        this.mins = lArray;
    }

    @Override
    long get(int n2, int n3) {
        return this.mins[n2] + this.values[n2].get(n3);
    }

    @Override
    int decodeBlock(int n2, long[] lArray) {
        int n3 = super.decodeBlock(n2, lArray);
        long l2 = this.mins[n2];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] + l2;
        }
        return n3;
    }

    static class Builder
    extends PackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        long[] mins;

        Builder(int n2, float f2) {
            super(n2, f2);
            this.mins = new long[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public DeltaPackedLongValues build() {
            this.finish();
            this.pending = null;
            a[] aArray = Arrays.copyOf(this.values, this.valuesOff);
            long[] lArray = Arrays.copyOf(this.mins, this.valuesOff);
            long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(aArray) + RamUsageEstimator.sizeOf(lArray);
            return new DeltaPackedLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])aArray, lArray, this.size, l2);
        }

        @Override
        void pack(long[] lArray, int n2, int n3, float f2) {
            int n4;
            long l2 = lArray[0];
            for (n4 = 1; n4 < n2; ++n4) {
                l2 = Math.min(l2, lArray[n4]);
            }
            n4 = 0;
            while (n4 < n2) {
                int n5 = n4++;
                lArray[n5] = lArray[n5] - l2;
            }
            super.pack(lArray, n2, n3, f2);
            this.mins[n3] = l2;
        }

        @Override
        void grow(int n2) {
            super.grow(n2);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.mins);
            this.mins = Arrays.copyOf(this.mins, n2);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }
    }
}

