/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.h;
import org.apache.lucene.util.LongValues;

public class DirectReader {
    public static LongValues a(h h2, int n2) {
        switch (n2) {
            case 1: {
                return new DirectPackedReader1(h2);
            }
            case 2: {
                return new DirectPackedReader2(h2);
            }
            case 4: {
                return new DirectPackedReader4(h2);
            }
            case 8: {
                return new DirectPackedReader8(h2);
            }
            case 12: {
                return new DirectPackedReader12(h2);
            }
            case 16: {
                return new DirectPackedReader16(h2);
            }
            case 20: {
                return new DirectPackedReader20(h2);
            }
            case 24: {
                return new DirectPackedReader24(h2);
            }
            case 28: {
                return new DirectPackedReader28(h2);
            }
            case 32: {
                return new DirectPackedReader32(h2);
            }
            case 40: {
                return new DirectPackedReader40(h2);
            }
            case 48: {
                return new DirectPackedReader48(h2);
            }
            case 56: {
                return new DirectPackedReader56(h2);
            }
            case 64: {
                return new DirectPackedReader64(h2);
            }
        }
        throw new IllegalArgumentException("unsupported bitsPerValue: " + n2);
    }

    static final class DirectPackedReader64
    extends LongValues {
        final h in;

        DirectPackedReader64(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readLong(l2 << 3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader56
    extends LongValues {
        final h in;

        DirectPackedReader56(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readLong(l2 * 7L) >>> 8;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader48
    extends LongValues {
        final h in;

        DirectPackedReader48(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readLong(l2 * 6L) >>> 16;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader40
    extends LongValues {
        final h in;

        DirectPackedReader40(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readLong(l2 * 5L) >>> 24;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader32
    extends LongValues {
        final h in;

        DirectPackedReader32(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return (long)this.in.readInt(l2 << 2) & 0xFFFFFFFFL;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader28
    extends LongValues {
        final h in;

        DirectPackedReader28(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                long l3 = l2 * 28L >>> 3;
                int n2 = (int)(l2 + 1L & 1L) << 2;
                return (long)(this.in.readInt(l3) >>> n2) & 0xFFFFFFFL;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader24
    extends LongValues {
        final h in;

        DirectPackedReader24(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readInt(l2 * 3L) >>> 8;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader20
    extends LongValues {
        final h in;

        DirectPackedReader20(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                long l3 = l2 * 20L >>> 3;
                int n2 = this.in.readInt(l3) >>> 8;
                int n3 = (int)(l2 + 1L & 1L) << 2;
                return n2 >>> n3 & 0xFFFFF;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader16
    extends LongValues {
        final h in;

        DirectPackedReader16(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readShort(l2 << 1) & 0xFFFF;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader12
    extends LongValues {
        final h in;

        DirectPackedReader12(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                long l3 = l2 * 12L >>> 3;
                int n2 = (int)(l2 + 1L & 1L) << 2;
                return this.in.readShort(l3) >>> n2 & 0xFFF;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader8
    extends LongValues {
        final h in;

        DirectPackedReader8(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                return this.in.readByte(l2) & 0xFF;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader4
    extends LongValues {
        final h in;

        DirectPackedReader4(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                int n2 = (int)(l2 + 1L & 1L) << 2;
                return this.in.readByte(l2 >>> 1) >>> n2 & 0xF;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader2
    extends LongValues {
        final h in;

        DirectPackedReader2(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                int n2 = 3 - (int)(l2 & 3L) << 1;
                return this.in.readByte(l2 >>> 2) >>> n2 & 3;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static final class DirectPackedReader1
    extends LongValues {
        final h in;

        DirectPackedReader1(h h2) {
            this.in = h2;
        }

        @Override
        public long get(long l2) {
            try {
                int n2 = 7 - (int)(l2 & 7L);
                return this.in.readByte(l2 >>> 3) >>> n2 & 1;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

