/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

public final class DirectWriter {
    final int bitsPerValue;
    final long numValues;
    final IndexOutput output;
    long count;
    boolean finished;
    int off;
    final byte[] nextBlocks;
    final long[] nextValues;
    final BulkOperation encoder;
    final int iterations;
    static final int[] SUPPORTED_BITS_PER_VALUE = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64};

    DirectWriter(IndexOutput indexOutput, long l2, int n2) {
        this.output = indexOutput;
        this.numValues = l2;
        this.bitsPerValue = n2;
        this.encoder = BulkOperation.of(PackedInts.Format.PACKED, n2);
        this.iterations = this.encoder.computeIterations((int)Math.min(l2, Integer.MAX_VALUE), 1024);
        this.nextBlocks = new byte[this.iterations * this.encoder.byteBlockCount()];
        this.nextValues = new long[this.iterations * this.encoder.byteValueCount()];
    }

    public void add(long l2) throws IOException {
        assert (this.bitsPerValue == 64 || l2 >= 0L && l2 <= PackedInts.maxValue(this.bitsPerValue)) : this.bitsPerValue;
        assert (!this.finished);
        if (this.count >= this.numValues) {
            throw new EOFException("Writing past end of stream");
        }
        this.nextValues[this.off++] = l2;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        ++this.count;
    }

    private void flush() throws IOException {
        this.encoder.encode(this.nextValues, 0, this.nextBlocks, 0, this.iterations);
        int n2 = (int)PackedInts.Format.PACKED.byteCount(2, this.off, this.bitsPerValue);
        this.output.writeBytes(this.nextBlocks, n2);
        Arrays.fill(this.nextValues, 0L);
        this.off = 0;
    }

    public void finish() throws IOException {
        if (this.count != this.numValues) {
            throw new IllegalStateException("Wrong number of values added, expected: " + this.numValues + ", got: " + this.count);
        }
        assert (!this.finished);
        this.flush();
        for (int i2 = 0; i2 < 3; ++i2) {
            this.output.writeByte((byte)0);
        }
        this.finished = true;
    }

    public static DirectWriter getInstance(IndexOutput indexOutput, long l2, int n2) {
        if (Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, n2) < 0) {
            throw new IllegalArgumentException("Unsupported bitsPerValue " + n2 + ". Did you use bitsRequired?");
        }
        return new DirectWriter(indexOutput, l2, n2);
    }

    private static int roundBits(int n2) {
        int n3 = Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, n2);
        if (n3 < 0) {
            return SUPPORTED_BITS_PER_VALUE[-n3 - 1];
        }
        return n2;
    }

    public static int bitsRequired(long l2) {
        return DirectWriter.roundBits(PackedInts.bitsRequired(l2));
    }

    public static int unsignedBitsRequired(long l2) {
        return DirectWriter.roundBits(PackedInts.unsignedBitsRequired(l2));
    }
}

