/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.m;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.Direct16;
import org.apache.lucene.util.packed.Direct32;
import org.apache.lucene.util.packed.Direct64;
import org.apache.lucene.util.packed.Direct8;
import org.apache.lucene.util.packed.DirectPacked64SingleBlockReader;
import org.apache.lucene.util.packed.DirectPackedReader;
import org.apache.lucene.util.packed.Packed16ThreeBlocks;
import org.apache.lucene.util.packed.Packed64;
import org.apache.lucene.util.packed.Packed64SingleBlock;
import org.apache.lucene.util.packed.Packed8ThreeBlocks;
import org.apache.lucene.util.packed.PackedReaderIterator;
import org.apache.lucene.util.packed.PackedWriter;

public class PackedInts {
    public static void checkVersion(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Version is too old, should be at least 0 (got " + n2 + ")");
        }
        if (n2 > 2) {
            throw new IllegalArgumentException("Version is too new, should be at most 2 (got " + n2 + ")");
        }
    }

    public static FormatAndBits fastestFormatAndBits(int n2, int n3, float f2) {
        if (n2 == -1) {
            n2 = Integer.MAX_VALUE;
        }
        f2 = Math.max(0.0f, f2);
        f2 = Math.min(7.0f, f2);
        float f3 = f2 * (float)n3;
        int n4 = n3 + (int)f3;
        int n5 = -1;
        Format format = Format.PACKED;
        if (n3 <= 8 && n4 >= 8) {
            n5 = 8;
        } else if (n3 <= 16 && n4 >= 16) {
            n5 = 16;
        } else if (n3 <= 32 && n4 >= 32) {
            n5 = 32;
        } else if (n3 <= 64 && n4 >= 64) {
            n5 = 64;
        } else if (n2 <= 0x2AAAAAAA && n3 <= 24 && n4 >= 24) {
            n5 = 24;
        } else if (n2 <= 0x2AAAAAAA && n3 <= 48 && n4 >= 48) {
            n5 = 48;
        } else {
            for (int i2 = n3; i2 <= n4; ++i2) {
                float f4;
                float f5;
                if (!Format.PACKED_SINGLE_BLOCK.isSupported(i2) || !((f5 = Format.PACKED_SINGLE_BLOCK.overheadPerValue(i2)) <= (f4 = f3 + (float)n3 - (float)i2))) continue;
                n5 = i2;
                format = Format.PACKED_SINGLE_BLOCK;
                break;
            }
            if (n5 < 0) {
                n5 = n3;
            }
        }
        return new FormatAndBits(format, n5);
    }

    public static a getDecoder(Format format, int n2, int n3) {
        PackedInts.checkVersion(n2);
        return BulkOperation.of(format, n3);
    }

    public static b getEncoder(Format format, int n2, int n3) {
        PackedInts.checkVersion(n2);
        return BulkOperation.of(format, n3);
    }

    public static Reader getReaderNoHeader(DataInput dataInput, Format format, int n2, int n3, int n4) throws IOException {
        PackedInts.checkVersion(n2);
        switch (format) {
            case PACKED_SINGLE_BLOCK: {
                return Packed64SingleBlock.create(dataInput, n3, n4);
            }
            case PACKED: {
                switch (n4) {
                    case 8: {
                        return new Direct8(n2, dataInput, n3);
                    }
                    case 16: {
                        return new Direct16(n2, dataInput, n3);
                    }
                    case 32: {
                        return new Direct32(n2, dataInput, n3);
                    }
                    case 64: {
                        return new Direct64(n2, dataInput, n3);
                    }
                    case 24: {
                        if (n3 > 0x2AAAAAAA) break;
                        return new Packed8ThreeBlocks(n2, dataInput, n3);
                    }
                    case 48: {
                        if (n3 > 0x2AAAAAAA) break;
                        return new Packed16ThreeBlocks(n2, dataInput, n3);
                    }
                }
                return new Packed64(n2, dataInput, n3, n4);
            }
        }
        throw new AssertionError((Object)("Unknown Writer format: " + (Object)((Object)format)));
    }

    public static Reader getReader(DataInput dataInput) throws IOException {
        int n2 = CodecUtil.checkHeader(dataInput, "PackedInts", 0, 2);
        int n3 = dataInput.readVInt();
        assert (n3 > 0 && n3 <= 64) : "bitsPerValue=" + n3;
        int n4 = dataInput.readVInt();
        Format format = Format.byId(dataInput.readVInt());
        return PackedInts.getReaderNoHeader(dataInput, format, n2, n4, n3);
    }

    public static c getReaderIteratorNoHeader(DataInput dataInput, Format format, int n2, int n3, int n4, int n5) {
        PackedInts.checkVersion(n2);
        return new PackedReaderIterator(format, n2, n3, n4, dataInput, n5);
    }

    public static Reader getDirectReaderNoHeader(IndexInput indexInput, Format format, int n2, int n3, int n4) {
        PackedInts.checkVersion(n2);
        switch (format) {
            case PACKED: {
                long l2 = format.byteCount(n2, n3, n4);
                if (l2 != format.byteCount(2, n3, n4)) {
                    assert (n2 == 0);
                    final long l3 = indexInput.getFilePointer() + l2;
                    return new DirectPackedReader(n4, n3, indexInput){

                        @Override
                        public long get(int n2) {
                            long l2 = super.get(n2);
                            if (n2 == this.valueCount - 1) {
                                try {
                                    this.in.seek(l3);
                                }
                                catch (IOException iOException) {
                                    throw new IllegalStateException("failed", iOException);
                                }
                            }
                            return l2;
                        }
                    };
                }
                return new DirectPackedReader(n4, n3, indexInput);
            }
            case PACKED_SINGLE_BLOCK: {
                return new DirectPacked64SingleBlockReader(n4, n3, indexInput);
            }
        }
        throw new AssertionError((Object)("Unknwown format: " + (Object)((Object)format)));
    }

    public static Mutable getMutable(int n2, int n3, float f2) {
        FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(n2, n3, f2);
        return PackedInts.getMutable(n2, formatAndBits.bitsPerValue, formatAndBits.format);
    }

    public static Mutable getMutable(int n2, int n3, Format format) {
        assert (n2 >= 0);
        switch (format) {
            case PACKED_SINGLE_BLOCK: {
                return Packed64SingleBlock.create(n2, n3);
            }
            case PACKED: {
                switch (n3) {
                    case 8: {
                        return new Direct8(n2);
                    }
                    case 16: {
                        return new Direct16(n2);
                    }
                    case 32: {
                        return new Direct32(n2);
                    }
                    case 64: {
                        return new Direct64(n2);
                    }
                    case 24: {
                        if (n2 > 0x2AAAAAAA) break;
                        return new Packed8ThreeBlocks(n2);
                    }
                    case 48: {
                        if (n2 > 0x2AAAAAAA) break;
                        return new Packed16ThreeBlocks(n2);
                    }
                }
                return new Packed64(n2, n3);
            }
        }
        throw new AssertionError();
    }

    public static Writer getWriterNoHeader(DataOutput dataOutput, Format format, int n2, int n3, int n4) {
        return new PackedWriter(format, dataOutput, n2, n3, n4);
    }

    public static int bitsRequired(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("maxValue must be non-negative (got: " + l2 + ")");
        }
        return PackedInts.unsignedBitsRequired(l2);
    }

    public static int unsignedBitsRequired(long l2) {
        return Math.max(1, 64 - Long.numberOfLeadingZeros(l2));
    }

    public static long maxValue(int n2) {
        return n2 == 64 ? Long.MAX_VALUE : -1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void copy(Reader reader, int n2, Mutable mutable, int n3, int n4, int n5) {
        assert (n2 + n4 <= reader.size());
        assert (n3 + n4 <= mutable.size());
        int n6 = n5 >>> 3;
        if (n6 == 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                mutable.set(n3++, reader.get(n2++));
            }
        } else if (n4 > 0) {
            long[] lArray = new long[Math.min(n6, n4)];
            PackedInts.copy(reader, n2, mutable, n3, n4, lArray);
        }
    }

    static void copy(Reader reader, int n2, Mutable mutable, int n3, int n4, long[] lArray) {
        int n5;
        assert (lArray.length > 0);
        int n6 = 0;
        while (n4 > 0) {
            n5 = reader.get(n2, lArray, n6, Math.min(n4, lArray.length - n6));
            assert (n5 > 0);
            n2 += n5;
            n4 -= n5;
            int n7 = mutable.set(n3, lArray, 0, n6 += n5);
            assert (n7 > 0);
            n3 += n7;
            if (n7 < n6) {
                System.arraycopy(lArray, n7, lArray, 0, n6 - n7);
            }
            n6 -= n7;
        }
        while (n6 > 0) {
            n5 = mutable.set(n3, lArray, 0, n6);
            n3 += n5;
            System.arraycopy(lArray, n5, lArray, 0, n6 -= n5);
        }
    }

    static int checkBlockSize(int n2, int n3, int n4) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalArgumentException("blockSize must be >= " + n3 + " and <= " + n4 + ", got " + n2);
        }
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("blockSize must be a power of two, got " + n2);
        }
        return Integer.numberOfTrailingZeros(n2);
    }

    static int numBlocks(long l2, int n2) {
        int n3 = (int)(l2 / (long)n2) + (l2 % (long)n2 == 0L ? 0 : 1);
        if ((long)n3 * (long)n2 < l2) {
            throw new IllegalArgumentException("size is too large for this block size");
        }
        return n3;
    }

    public static abstract class Writer {
        protected final DataOutput out;
        protected final int valueCount;
        protected final int bitsPerValue;

        protected Writer(DataOutput dataOutput, int n2, int n3) {
            assert (n3 <= 64);
            assert (n2 >= 0 || n2 == -1);
            this.out = dataOutput;
            this.valueCount = n2;
            this.bitsPerValue = n3;
        }

        void writeHeader() throws IOException {
            assert (this.valueCount != -1);
            CodecUtil.writeHeader(this.out, "PackedInts", 2);
            this.out.writeVInt(this.bitsPerValue);
            this.out.writeVInt(this.valueCount);
            this.out.writeVInt(this.getFormat().getId());
        }

        protected abstract Format getFormat();

        public abstract void add(long var1) throws IOException;

        public final int bitsPerValue() {
            return this.bitsPerValue;
        }

        public abstract void finish() throws IOException;

        public abstract int ord();
    }

    public static final class NullReader
    extends Reader {
        private final int valueCount;

        public NullReader(int n2) {
            this.valueCount = n2;
        }

        @Override
        public long get(int n2) {
            return 0L;
        }

        @Override
        public int get(int n2, long[] lArray, int n3, int n4) {
            assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
            assert (n2 >= 0 && n2 < this.valueCount);
            n4 = Math.min(n4, this.valueCount - n2);
            Arrays.fill(lArray, n3, n3 + n4, 0L);
            return n4;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
        }
    }

    static abstract class MutableImpl
    extends Mutable {
        protected final int valueCount;
        protected final int bitsPerValue;

        protected MutableImpl(int n2, int n3) {
            this.valueCount = n2;
            assert (n3 > 0 && n3 <= 64) : "bitsPerValue=" + n3;
            this.bitsPerValue = n3;
        }

        @Override
        public final int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public final int size() {
            return this.valueCount;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(valueCount=" + this.valueCount + ",bitsPerValue=" + this.bitsPerValue + ")";
        }
    }

    static abstract class ReaderImpl
    extends Reader {
        protected final int valueCount;

        protected ReaderImpl(int n2) {
            this.valueCount = n2;
        }

        @Override
        public final int size() {
            return this.valueCount;
        }
    }

    public static abstract class Mutable
    extends Reader {
        public abstract int getBitsPerValue();

        public abstract void set(int var1, long var2);

        public int set(int n2, long[] lArray, int n3, int n4) {
            assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
            assert (n2 >= 0 && n2 < this.size());
            n4 = Math.min(n4, this.size() - n2);
            assert (n3 + n4 <= lArray.length);
            int n5 = n2;
            int n6 = n3;
            int n7 = n2 + n4;
            while (n5 < n7) {
                this.set(n5, lArray[n6]);
                ++n5;
                ++n6;
            }
            return n4;
        }

        public void fill(int n2, int n3, long l2) {
            assert (l2 <= PackedInts.maxValue(this.getBitsPerValue()));
            assert (n2 <= n3);
            for (int i2 = n2; i2 < n3; ++i2) {
                this.set(i2, l2);
            }
        }

        public void clear() {
            this.fill(0, this.size(), 0L);
        }

        public void save(DataOutput dataOutput) throws IOException {
            Writer writer = PackedInts.getWriterNoHeader(dataOutput, this.getFormat(), this.size(), this.getBitsPerValue(), 1024);
            writer.writeHeader();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                writer.add(this.get(i2));
            }
            writer.finish();
        }

        Format getFormat() {
            return Format.PACKED;
        }
    }

    static abstract class ReaderIteratorImpl
    implements c {
        protected final DataInput in;
        protected final int bitsPerValue;
        protected final int valueCount;

        protected ReaderIteratorImpl(int n2, int n3, DataInput dataInput) {
            this.in = dataInput;
            this.bitsPerValue = n3;
            this.valueCount = n2;
        }

        @Override
        public long next() throws IOException {
            LongsRef longsRef = this.next(1);
            assert (longsRef.length > 0);
            long l2 = longsRef.longs[longsRef.offset];
            ++longsRef.offset;
            --longsRef.length;
            return l2;
        }
    }

    public static interface c {
        public long next() throws IOException;

        public LongsRef next(int var1) throws IOException;
    }

    public static abstract class Reader
    extends m
    implements org.apache.lucene.util.a {
        public int get(int n2, long[] lArray, int n3, int n4) {
            assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
            assert (n2 >= 0 && n2 < this.size());
            assert (n3 + n4 <= lArray.length);
            int n5 = Math.min(this.size() - n2, n4);
            int n6 = n2;
            int n7 = n3;
            int n8 = n2 + n5;
            while (n6 < n8) {
                lArray[n7] = this.get(n6);
                ++n6;
                ++n7;
            }
            return n5;
        }

        public abstract int size();

        @Override
        public Collection<org.apache.lucene.util.a> getChildResources() {
            return Collections.emptyList();
        }
    }

    public static interface b {
        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void encode(long[] var1, int var2, long[] var3, int var4, int var5);

        public void encode(long[] var1, int var2, byte[] var3, int var4, int var5);

        public void encode(int[] var1, int var2, byte[] var3, int var4, int var5);
    }

    public static interface a {
        public int longBlockCount();

        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void decode(long[] var1, int var2, long[] var3, int var4, int var5);

        public void decode(byte[] var1, int var2, long[] var3, int var4, int var5);

        public void decode(byte[] var1, int var2, int[] var3, int var4, int var5);
    }

    public static class FormatAndBits {
        public final Format format;
        public final int bitsPerValue;

        public FormatAndBits(Format format, int n2) {
            this.format = format;
            this.bitsPerValue = n2;
        }

        public String toString() {
            return "FormatAndBits(format=" + (Object)((Object)this.format) + " bitsPerValue=" + this.bitsPerValue + ")";
        }
    }

    public static class Format
    extends Enum<Format> {
        public static final /* enum */ Format PACKED = new Format(0){

            @Override
            public long byteCount(int n2, int n3, int n4) {
                if (n2 < 1) {
                    return 8L * (long)Math.ceil((double)n3 * (double)n4 / 64.0);
                }
                return (long)Math.ceil((double)n3 * (double)n4 / 8.0);
            }
        };
        public static final /* enum */ Format PACKED_SINGLE_BLOCK = new Format(1){

            @Override
            public int longCount(int n2, int n3, int n4) {
                int n5 = 64 / n4;
                return (int)Math.ceil((double)n3 / (double)n5);
            }

            @Override
            public boolean isSupported(int n2) {
                return Packed64SingleBlock.isSupported(n2);
            }

            @Override
            public float overheadPerValue(int n2) {
                assert (this.isSupported(n2));
                int n3 = 64 / n2;
                int n4 = 64 % n2;
                return (float)n4 / (float)n3;
            }
        };
        public int id;
        private static final /* synthetic */ Format[] $VALUES;

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String string) {
            return Enum.valueOf(Format.class, string);
        }

        public static Format byId(int n2) {
            for (Format format : Format.values()) {
                if (format.getId() != n2) continue;
                return format;
            }
            throw new IllegalArgumentException("Unknown format id: " + n2);
        }

        private Format(int n3) {
            this.id = n3;
        }

        public int getId() {
            return this.id;
        }

        public long byteCount(int n2, int n3, int n4) {
            assert (n4 >= 0 && n4 <= 64) : n4;
            return 8L * (long)this.longCount(n2, n3, n4);
        }

        public int longCount(int n2, int n3, int n4) {
            assert (n4 >= 0 && n4 <= 64) : n4;
            long l2 = this.byteCount(n2, n3, n4);
            assert (l2 < 0x3FFFFFFF8L);
            if (l2 % 8L == 0L) {
                return (int)(l2 / 8L);
            }
            return (int)(l2 / 8L + 1L);
        }

        public boolean isSupported(int n2) {
            return n2 >= 1 && n2 <= 64;
        }

        public float overheadPerValue(int n2) {
            assert (this.isSupported(n2));
            return 0.0f;
        }

        static {
            $VALUES = new Format[]{PACKED, PACKED_SINGLE_BLOCK};
        }
    }
}

