/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.ReusableStringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.Version;

public abstract class Analyzer
implements Closeable {
    private final a reuseStrategy;
    private Version version = Version.LATEST;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    public static final a GLOBAL_REUSE_STRATEGY = new a(){

        @Override
        public TokenStreamComponents a(Analyzer analyzer, String string) {
            return (TokenStreamComponents)this.a(analyzer);
        }

        @Override
        public void a(Analyzer analyzer, String string, TokenStreamComponents tokenStreamComponents) {
            this.a(analyzer, tokenStreamComponents);
        }
    };
    public static final a PER_FIELD_REUSE_STRATEGY = new a(){

        @Override
        public TokenStreamComponents a(Analyzer analyzer, String string) {
            Map map = (Map)this.a(analyzer);
            return map != null ? (TokenStreamComponents)map.get(string) : null;
        }

        @Override
        public void a(Analyzer analyzer, String string, TokenStreamComponents tokenStreamComponents) {
            HashMap<String, TokenStreamComponents> hashMap = (HashMap<String, TokenStreamComponents>)this.a(analyzer);
            if (hashMap == null) {
                hashMap = new HashMap<String, TokenStreamComponents>();
                this.a(analyzer, hashMap);
            }
            hashMap.put(string, tokenStreamComponents);
        }
    };

    public Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    public Analyzer(a a2) {
        this.reuseStrategy = a2;
    }

    protected abstract TokenStreamComponents createComponents(String var1);

    public final TokenStream tokenStream(String string, Reader reader) throws IOException {
        TokenStreamComponents tokenStreamComponents = this.reuseStrategy.a(this, string);
        Reader reader2 = this.initReader(string, reader);
        if (tokenStreamComponents == null) {
            tokenStreamComponents = this.createComponents(string);
            this.reuseStrategy.a(this, string, tokenStreamComponents);
        }
        tokenStreamComponents.setReader(reader2);
        return tokenStreamComponents.getTokenStream();
    }

    public final TokenStream tokenStream(String string, String string2) throws IOException {
        TokenStreamComponents tokenStreamComponents = this.reuseStrategy.a(this, string);
        ReusableStringReader reusableStringReader = tokenStreamComponents == null || tokenStreamComponents.reusableStringReader == null ? new ReusableStringReader() : tokenStreamComponents.reusableStringReader;
        reusableStringReader.setValue(string2);
        Reader reader = this.initReader(string, reusableStringReader);
        if (tokenStreamComponents == null) {
            tokenStreamComponents = this.createComponents(string);
            this.reuseStrategy.a(this, string, tokenStreamComponents);
        }
        tokenStreamComponents.setReader(reader);
        tokenStreamComponents.reusableStringReader = reusableStringReader;
        return tokenStreamComponents.getTokenStream();
    }

    protected Reader initReader(String string, Reader reader) {
        return reader;
    }

    public int getPositionIncrementGap(String string) {
        return 0;
    }

    public int getOffsetGap(String string) {
        return 1;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    public static abstract class a {
        public abstract TokenStreamComponents a(Analyzer var1, String var2);

        public abstract void a(Analyzer var1, String var2, TokenStreamComponents var3);

        protected final Object a(Analyzer analyzer) {
            if (analyzer.storedValue == null) {
                throw new org.apache.lucene.store.a("this Analyzer is closed");
            }
            return analyzer.storedValue.get();
        }

        protected final void a(Analyzer analyzer, Object object) {
            if (analyzer.storedValue == null) {
                throw new org.apache.lucene.store.a("this Analyzer is closed");
            }
            analyzer.storedValue.set(object);
        }
    }

    public static class TokenStreamComponents {
        @Weak
        protected final Tokenizer source;
        @Weak
        protected final TokenStream sink;
        @Weak
        transient ReusableStringReader reusableStringReader;

        public TokenStreamComponents(Tokenizer tokenizer) {
            this.source = tokenizer;
            this.sink = tokenizer;
        }

        protected void setReader(Reader reader) throws IOException {
            this.source.setReader(reader);
        }

        public TokenStream getTokenStream() {
            return this.sink;
        }
    }
}

