/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;
import org.apache.lucene.util.i;

public final class NumericTokenStream
extends TokenStream {
    private final NumericTermAttribute numericAtt = this.addAttribute(NumericTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int valSize = 0;
    private final int precisionStep;

    public NumericTokenStream() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, 16);
    }

    public NumericTokenStream(int n2) {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, n2);
    }

    public NumericTokenStream(AttributeFactory attributeFactory, int n2) {
        super(new NumericAttributeFactory(attributeFactory));
        if (n2 < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = n2;
        this.numericAtt.setShift(-n2);
    }

    public NumericTokenStream setLongValue(long l2) {
        this.valSize = 64;
        this.numericAtt.init(l2, 64, this.precisionStep, -this.precisionStep);
        return this;
    }

    public NumericTokenStream setIntValue(int n2) {
        this.valSize = 32;
        this.numericAtt.init(n2, 32, this.precisionStep, -this.precisionStep);
        return this;
    }

    public NumericTokenStream setDoubleValue(double d2) {
        this.valSize = 64;
        this.numericAtt.init(i.a(d2), 64, this.precisionStep, -this.precisionStep);
        return this;
    }

    public NumericTokenStream setFloatValue(float f2) {
        this.valSize = 32;
        this.numericAtt.init(i.a(f2), 32, this.precisionStep, -this.precisionStep);
        return this;
    }

    @Override
    public void reset() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
        this.numericAtt.setShift(-this.precisionStep);
    }

    @Override
    public boolean incrementToken() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
        this.clearAttributes();
        int n2 = this.numericAtt.incShift();
        this.typeAtt.setType(n2 == 0 ? "fullPrecNumeric" : "lowerPrecNumeric");
        this.posIncrAtt.setPositionIncrement(n2 == 0 ? 1 : 0);
        return n2 < this.valSize;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(precisionStep=" + this.precisionStep + " valueSize=" + this.numericAtt.getValueSize() + " shift=" + this.numericAtt.getShift() + ")";
    }

    public static final class NumericTermAttributeImpl
    extends AttributeImpl
    implements NumericTermAttribute,
    TermToBytesRefAttribute {
        private long value = 0L;
        private int valueSize = 0;
        private int shift = 0;
        private int precisionStep = 0;
        private BytesRefBuilder bytes = new BytesRefBuilder();

        @Override
        public BytesRef getBytesRef() {
            assert (this.valueSize == 64 || this.valueSize == 32);
            if (this.valueSize == 64) {
                i.a(this.value, this.shift, this.bytes);
            } else {
                i.a((int)this.value, this.shift, this.bytes);
            }
            return this.bytes.get();
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public void setShift(int n2) {
            this.shift = n2;
        }

        @Override
        public int incShift() {
            return this.shift += this.precisionStep;
        }

        @Override
        public long getRawValue() {
            return this.value & ((1L << this.shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public int getValueSize() {
            return this.valueSize;
        }

        @Override
        public void init(long l2, int n2, int n3, int n4) {
            this.value = l2;
            this.valueSize = n2;
            this.precisionStep = n3;
            this.shift = n4;
        }

        @Override
        public void clear() {
        }

        @Override
        public void reflectWith(d d2) {
            d2.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
            d2.reflect(NumericTermAttribute.class, "shift", this.shift);
            d2.reflect(NumericTermAttribute.class, "rawValue", this.getRawValue());
            d2.reflect(NumericTermAttribute.class, "valueSize", this.valueSize);
        }

        @Override
        public void copyTo(AttributeImpl attributeImpl) {
            NumericTermAttribute numericTermAttribute = (NumericTermAttribute)((Object)attributeImpl);
            numericTermAttribute.init(this.value, this.valueSize, this.precisionStep, this.shift);
        }

        @Override
        public NumericTermAttributeImpl clone() {
            NumericTermAttributeImpl numericTermAttributeImpl = (NumericTermAttributeImpl)super.clone();
            numericTermAttributeImpl.bytes = new BytesRefBuilder();
            numericTermAttributeImpl.bytes.copyBytes(this.getBytesRef());
            return numericTermAttributeImpl;
        }

        public int hashCode() {
            return Objects.hash(this.precisionStep, this.shift, this.value, this.valueSize);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NumericTermAttributeImpl numericTermAttributeImpl = (NumericTermAttributeImpl)object;
            if (this.precisionStep != numericTermAttributeImpl.precisionStep) {
                return false;
            }
            if (this.shift != numericTermAttributeImpl.shift) {
                return false;
            }
            if (this.value != numericTermAttributeImpl.value) {
                return false;
            }
            return this.valueSize == numericTermAttributeImpl.valueSize;
        }
    }

    private static final class NumericAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        NumericAttributeFactory(AttributeFactory attributeFactory) {
            this.delegate = attributeFactory;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends c> clazz) {
            if (CharTermAttribute.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("NumericTokenStream does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(clazz);
        }
    }

    public static interface NumericTermAttribute
    extends c {
        public int getShift();

        public long getRawValue();

        public int getValueSize();

        public void init(long var1, int var3, int var4, int var5);

        public void setShift(int var1);

        public int incShift();
    }
}

