/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.nio.CharBuffer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.d;

public class CharTermAttributeImpl
extends AttributeImpl
implements Cloneable,
CharTermAttribute,
TermToBytesRefAttribute {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;
    protected BytesRefBuilder builder = new BytesRefBuilder();

    @Override
    public final void copyBuffer(char[] cArray, int n2, int n3) {
        this.growTermBuffer(n3);
        System.arraycopy(cArray, n2, this.termBuffer, 0, n3);
        this.termLength = n3;
    }

    @Override
    public final char[] buffer() {
        return this.termBuffer;
    }

    @Override
    public final char[] resizeBuffer(int n2) {
        if (this.termBuffer.length < n2) {
            char[] cArray = new char[ArrayUtil.oversize(n2, 2)];
            System.arraycopy(this.termBuffer, 0, cArray, 0, this.termBuffer.length);
            this.termBuffer = cArray;
        }
        return this.termBuffer;
    }

    private void growTermBuffer(int n2) {
        if (this.termBuffer.length < n2) {
            this.termBuffer = new char[ArrayUtil.oversize(n2, 2)];
        }
    }

    @Override
    public final CharTermAttribute setLength(int n2) {
        if (n2 > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + n2 + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = n2;
        return this;
    }

    @Override
    public final CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Override
    public BytesRef getBytesRef() {
        this.builder.copyChars(this.termBuffer, 0, this.termLength);
        return this.builder.get();
    }

    @Override
    public final int length() {
        return this.termLength;
    }

    @Override
    public final char charAt(int n2) {
        if (n2 >= this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.termBuffer[n2];
    }

    @Override
    public final CharSequence subSequence(int n2, int n3) {
        if (n2 > this.termLength || n3 > this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termBuffer, n2, n3 - n2);
    }

    @Override
    public final CharTermAttribute append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public final CharTermAttribute append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        int n4 = n3 - n2;
        int n5 = charSequence.length();
        if (n4 < 0 || n2 > n5 || n3 > n5) {
            throw new IndexOutOfBoundsException();
        }
        if (n4 == 0) {
            return this;
        }
        this.resizeBuffer(this.termLength + n4);
        if (n4 > 4) {
            if (charSequence instanceof String) {
                ((String)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else if (charSequence instanceof StringBuilder) {
                ((StringBuilder)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else if (charSequence instanceof CharTermAttribute) {
                System.arraycopy(((CharTermAttribute)charSequence).buffer(), n2, this.termBuffer, this.termLength, n4);
            } else if (charSequence instanceof CharBuffer && ((CharBuffer)charSequence).hasArray()) {
                CharBuffer charBuffer = (CharBuffer)charSequence;
                System.arraycopy(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position() + n2, this.termBuffer, this.termLength, n4);
            } else if (charSequence instanceof StringBuffer) {
                ((StringBuffer)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else {
                while (n2 < n3) {
                    this.termBuffer[this.termLength++] = charSequence.charAt(n2++);
                }
                return this;
            }
            this.termLength += n4;
            return this;
        }
        while (n2 < n3) {
            this.termBuffer[this.termLength++] = charSequence.charAt(n2++);
        }
        return this;
    }

    @Override
    public final CharTermAttribute append(char c2) {
        this.resizeBuffer((int)(this.termLength + 1))[this.termLength++] = c2;
        return this;
    }

    @Override
    public final CharTermAttribute append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n2 = string.length();
        string.getChars(0, n2, this.resizeBuffer(this.termLength + n2), this.termLength);
        this.termLength += n2;
        return this;
    }

    @Override
    public final CharTermAttribute append(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        int n2 = stringBuilder.length();
        stringBuilder.getChars(0, n2, this.resizeBuffer(this.termLength + n2), this.termLength);
        this.termLength += n2;
        return this;
    }

    @Override
    public final CharTermAttribute append(CharTermAttribute charTermAttribute) {
        if (charTermAttribute == null) {
            return this.appendNull();
        }
        int n2 = charTermAttribute.length();
        System.arraycopy(charTermAttribute.buffer(), 0, this.resizeBuffer(this.termLength + n2), this.termLength, n2);
        this.termLength += n2;
        return this;
    }

    private CharTermAttribute appendNull() {
        this.resizeBuffer(this.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        int n2 = this.termLength;
        n2 = n2 * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return n2;
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    @Override
    public CharTermAttributeImpl clone() {
        CharTermAttributeImpl charTermAttributeImpl = (CharTermAttributeImpl)super.clone();
        charTermAttributeImpl.termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, charTermAttributeImpl.termBuffer, 0, this.termLength);
        charTermAttributeImpl.builder = new BytesRefBuilder();
        charTermAttributeImpl.builder.copyBytes(this.builder.get());
        return charTermAttributeImpl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CharTermAttributeImpl) {
            CharTermAttributeImpl charTermAttributeImpl = (CharTermAttributeImpl)object;
            if (this.termLength != charTermAttributeImpl.termLength) {
                return false;
            }
            for (int i2 = 0; i2 < this.termLength; ++i2) {
                if (this.termBuffer[i2] == charTermAttributeImpl.termBuffer[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(d d2) {
        d2.reflect(CharTermAttribute.class, "term", this.toString());
        d2.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        CharTermAttribute charTermAttribute = (CharTermAttribute)((Object)attributeImpl);
        charTermAttribute.copyBuffer(this.termBuffer, 0, this.termLength);
    }
}

