/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.d;

public class OffsetAttributeImpl
extends AttributeImpl
implements Cloneable,
OffsetAttribute {
    private int startOffset;
    private int endOffset;

    @Override
    public int startOffset() {
        return this.startOffset;
    }

    @Override
    public void setOffset(int n2, int n3) {
        if (n2 < 0 || n3 < n2) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, startOffset=" + n2 + ",endOffset=" + n3);
        }
        this.startOffset = n2;
        this.endOffset = n3;
    }

    @Override
    public int endOffset() {
        return this.endOffset;
    }

    @Override
    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OffsetAttributeImpl) {
            OffsetAttributeImpl offsetAttributeImpl = (OffsetAttributeImpl)object;
            return offsetAttributeImpl.startOffset == this.startOffset && offsetAttributeImpl.endOffset == this.endOffset;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.startOffset;
        n2 = n2 * 31 + this.endOffset;
        return n2;
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        OffsetAttribute offsetAttribute = (OffsetAttribute)((Object)attributeImpl);
        offsetAttribute.setOffset(this.startOffset, this.endOffset);
    }

    @Override
    public void reflectWith(d d2) {
        d2.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        d2.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
    }
}

