/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.d;

public class PackedTokenAttributeImpl
extends CharTermAttributeImpl
implements OffsetAttribute,
PositionIncrementAttribute,
PositionLengthAttribute,
TypeAttribute {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int positionIncrement = 1;
    private int positionLength = 1;

    @Override
    public void setPositionIncrement(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + n2);
        }
        this.positionIncrement = n2;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public void setPositionLength(int n2) {
        this.positionLength = n2;
    }

    @Override
    public int getPositionLength() {
        return this.positionLength;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    @Override
    public void setOffset(int n2, int n3) {
        if (n2 < 0 || n3 < n2) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, startOffset=" + n2 + ",endOffset=" + n3);
        }
        this.startOffset = n2;
        this.endOffset = n3;
    }

    @Override
    public final String type() {
        return this.type;
    }

    @Override
    public final void setType(String string) {
        this.type = string;
    }

    @Override
    public void clear() {
        super.clear();
        this.positionLength = 1;
        this.positionIncrement = 1;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    @Override
    public PackedTokenAttributeImpl clone() {
        return (PackedTokenAttributeImpl)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl packedTokenAttributeImpl = (PackedTokenAttributeImpl)object;
            return this.startOffset == packedTokenAttributeImpl.startOffset && this.endOffset == packedTokenAttributeImpl.endOffset && this.positionIncrement == packedTokenAttributeImpl.positionIncrement && this.positionLength == packedTokenAttributeImpl.positionLength && (this.type == null ? packedTokenAttributeImpl.type == null : this.type.equals(packedTokenAttributeImpl.type)) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + this.startOffset;
        n2 = n2 * 31 + this.endOffset;
        n2 = n2 * 31 + this.positionIncrement;
        n2 = n2 * 31 + this.positionLength;
        if (this.type != null) {
            n2 = n2 * 31 + this.type.hashCode();
        }
        return n2;
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        if (attributeImpl instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl packedTokenAttributeImpl = (PackedTokenAttributeImpl)attributeImpl;
            packedTokenAttributeImpl.copyBuffer(this.buffer(), 0, this.length());
            packedTokenAttributeImpl.positionIncrement = this.positionIncrement;
            packedTokenAttributeImpl.positionLength = this.positionLength;
            packedTokenAttributeImpl.startOffset = this.startOffset;
            packedTokenAttributeImpl.endOffset = this.endOffset;
            packedTokenAttributeImpl.type = this.type;
        } else {
            super.copyTo(attributeImpl);
            ((OffsetAttribute)((Object)attributeImpl)).setOffset(this.startOffset, this.endOffset);
            ((PositionIncrementAttribute)((Object)attributeImpl)).setPositionIncrement(this.positionIncrement);
            ((PositionLengthAttribute)((Object)attributeImpl)).setPositionLength(this.positionLength);
            ((TypeAttribute)((Object)attributeImpl)).setType(this.type);
        }
    }

    @Override
    public void reflectWith(d d2) {
        super.reflectWith(d2);
        d2.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        d2.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
        d2.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
        d2.reflect(PositionLengthAttribute.class, "positionLength", this.positionLength);
        d2.reflect(TypeAttribute.class, "type", this.type);
    }
}

